#ifndef COLORGRI_H
#define COLORGRI_H
//========================================================================================
//
//     File:			ColorGri.h
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRGRID_H
#include <BRGrid.h>
#endif

#ifndef BRCOLOR_H
#include <BRColor.h>
#endif

#ifndef COLORWIN_H
#include "ColorWin.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

//========================================================================================
//	class cColorGrid
//
//  Description:  This is the color grid class for selecting colors.
//========================================================================================

class cColorGrid : public BR_CGrid
{
public:
	friend 			class cColorWindow;
	enum			{eMaxColors = 16};		// Maximum number of colors
	enum			{eColumnWidth = 30};	// Width of each color column
	enum			{eRowHeight = 20};		// Height of each color row
 	enum			{eNumRows = 2};			// Number of row in grid
	enum			{eNumColumns = 8};		// Number of columns in grid

					cColorGrid(	BR_CView *enclosure, 
								BR_CBureaucrat *supervisor,
								cDrawState *State);
	virtual			~cColorGrid();
	BR_CColor		GetCurColor();

	// Overriden methods
	virtual void DoCellDraw(GridRowNumber row, GridRowNumber column);
	virtual void DoCellClick(GridRowNumber row, GridRowNumber column);

private:
	cDrawState			*fDrawState;				// Pointer to Draw State
	short 				fcurRow;					// current selected row
	short				fcurColumn;					// current selected column
	static BR_CColor	fcolorArray[eMaxColors];	// array of colors for grid
	
	//
	//	Private Methods
	//
	static BR_CColor 	GetColor(short colorNum);
	short 				GetCurRow();
	short				GetCurColumn();

						BR_SETCLASSNAME(cColorGrid);
};

//----------------------------------------------------------------------------------------
// cColorGrid::GetColor
//----------------------------------------------------------------------------------------

inline static BR_CColor cColorGrid::GetColor(short colorNum)
{
	return fcolorArray[colorNum];
}

//----------------------------------------------------------------------------------------
// cColorGrid::GetCurRow
//----------------------------------------------------------------------------------------

inline short cColorGrid::GetCurRow()
{
	return fcurRow;
}

//----------------------------------------------------------------------------------------
// cColorGrid::GetCurColumn
//----------------------------------------------------------------------------------------

inline short cColorGrid::GetCurColumn()
{
	return fcurColumn;
}

//----------------------------------------------------------------------------------------
// cColorGrid::GetCurColor
//----------------------------------------------------------------------------------------

inline BR_CColor cColorGrid::GetCurColor()
{
	return fcolorArray[GetCurRow() * eNumColumns + GetCurColumn()];
}

#endif
