//========================================================================================
//
//     File:			myDrwVw.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   MYDRWVW_H
#include "myDrwVw.h"
#endif

#ifndef   MYDRAW_K
#include "myDraw.k"
#endif

#ifndef   MYDRWDOC_H
#include "myDrwDoc.h"
#endif

#ifndef   MYDRWMOU_H
#include "myDrwMou.h"
#endif

#ifndef   MYDRWOBJ_H
#include "myDrwObj.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__QUICKDRAW__)
#include	<QuickDraw.h>
#endif

#if defined(BR_BUILD_MAC) && !defined(__SYSEQU__)
#include	<SysEqu.h>
#endif

//========================================================================================
// CLASS CMyDrawView
//========================================================================================

//----------------------------------------------------------------------------------------
// CMyDrawView::CMyDrawView
//----------------------------------------------------------------------------------------

CMyDrawView::CMyDrawView(BR_CView* enclosure,
	BR_CBureaucrat* supervisor,
	const BR_CModule& module,
	BR_SResource& resource):
	BR_CView(enclosure, supervisor, module, resource)
{
}

//----------------------------------------------------------------------------------------
// CMyDrawView::~CMyDrawView
//----------------------------------------------------------------------------------------

CMyDrawView::~CMyDrawView()
{
}

//----------------------------------------------------------------------------------------
// CMyDrawView::DoClick
//----------------------------------------------------------------------------------------

void CMyDrawView::DoClick(const BR_CPoint& ptMouse, BR_CBureaucrat::KeyModifiers keys)
{
	CMyDrawDocument* theDocument = (CMyDrawDocument*)GetDocument();

	BR_CMouseAction* mouseAction;
	
	switch (theDocument->GetToolCommand())
	{
		case cmdSelect:
			SelectObject(ptMouse, keys, theDocument->GetObjectList());
			return;
			
		case cmdLine:
			mouseAction = new CMyLineAction(this);
			break;
			
		case cmdRect:
			mouseAction = new CMyRectAction(this);
			break;
			
		case cmdEllipse:
			mouseAction = new CMyEllipseAction(this);
			break;
			
		case cmdRRect:
			mouseAction = new CMyRRectAction(this, 10, 10);  // width and height should be user-settable
			break;
			
		default:
			BR_CView::DoClick(ptMouse, keys);
			return;
	}
	
	theDocument->DeselectAllObjects();
	SetMouseAction(mouseAction);
	BR_CView::DoClick(ptMouse, keys);
}

//----------------------------------------------------------------------------------------
// CMyDrawView::DoCommand
//----------------------------------------------------------------------------------------

BR_Boolean CMyDrawView::DoCommand(BR_CBureaucrat::CommandId commandId,
	BR_CObject* notifier, BR_Boolean callSupervisor)
{	
	switch (commandId)
	{
		case cmdRedraw:
			Refresh();
			break;
		
		case cmdLine:
		case cmdRect:
		case cmdEllipse:
		case cmdRRect:
			SetCursor(kCrossCursor);
			return (BR_CView::DoCommand(commandId, notifier, callSupervisor));
			
		case cmdSelect:
			SetCursor(kArrowCursor);
			return (BR_CView::DoCommand(commandId, notifier, callSupervisor));
		
		default:
			return (BR_CView::DoCommand(commandId, notifier, callSupervisor));
	}
	return (TRUE);
}

//----------------------------------------------------------------------------------------
// CMyDrawView::Draw
//----------------------------------------------------------------------------------------

void CMyDrawView::Draw(BR_CCanvas &canvas, const BR_CRectangle &area)
{
	CMyDrawDocument* theDocument = (CMyDrawDocument*)GetDocument();

	// Draw all objects first, in case they overlap
	DO(theDocument->GetObjectList(), CMyDrawObject, dObject)
		dObject->Draw(this);
	ENDDO

	// Now draw the highlighting
	DO(theDocument->GetObjectList(), CMyDrawObject, dObject)
		dObject->HighlightIfSelected(this);
	ENDDO

	BR_CView::Draw(canvas, area);
}

//----------------------------------------------------------------------------------------
// CMyDrawView::Hilite
//----------------------------------------------------------------------------------------

void CMyDrawView::Hilite(const BR_CRectangle &area)
{
	// (Bedrock needs a method like this.)
#ifdef BR_BUILD_WIN
	BR_CColor sysBackgroundColor = BR_CSystem::GetSysColor(COLOR_HIGHLIGHT);
	BR_CWallPaper selectionColor(sysBackgroundColor);
	BR_CGraphicsToolSelector gts1(&pane, &selectionColor);
	BR_CColor selectionPenColor(sysBackgroundColor);
	BR_CPen selectionPen(selectionPenColor);
	BR_CGraphicsToolSelector gts2(&pane, &selectionPen);

	BR_RasterOperation saveMode = GetDrawMode();
	SetDrawMode(BEDDM_NOTXORPEN);
	DrawRectangle(area);
	SetDrawMode(saveMode);
#endif

#ifdef BR_BUILD_MAC
	BitClr(Ptr(HiliteMode), pHiliteBit);
	InvertRectangle(area);
#endif
}

//----------------------------------------------------------------------------------------
// CMyDrawView::SelectObject
//----------------------------------------------------------------------------------------

void CMyDrawView::SelectObject(const BR_CPoint& ptMouse, BR_CBureaucrat::KeyModifiers keys,
						BR_COrderedCollection& objectList)
{
	BR_CDrawInitiator di(this);
	
	CMyDrawObject* topMostObject = NULL;
	
	// Find the last object that contains the mouse, the topmost object.
	// (It would be more efficient to iterate backward, stopping at the first hit mouse.)
	DO(objectList, CMyDrawObject, dObject)
		if (dObject->IsPointInShape(ptMouse))
			topMostObject = dObject;
	ENDDO
	
	if (keys & 512 /*kShiftModifier*/ )	// kShiftModifier currently has the wrong value.
	{
		// extending the selection, so invert the select state of the topmost object, if any
		if (topMostObject)
			topMostObject->SetSelectAndDraw(!topMostObject->GetSelect(), this);
	}
	else
	{
		// Not extending, so set the selection of all the objects, selecting the topmost, if any.
		DO(objectList, CMyDrawObject, dObject)
			dObject->SetSelectAndDraw(dObject == topMostObject, this);
		ENDDO
	}
}

//----------------------------------------------------------------------------------------
// CMyDrawView::UpdateMenus
//----------------------------------------------------------------------------------------

void CMyDrawView::UpdateMenus(BR_CMenuBar& menuBar, BR_Boolean callSupervisor)
{
	BR_CView::UpdateMenus(menuBar, callSupervisor);
	menuBar.EnableCmd(cmdRedraw);
}

