//========================================================================================
//
//     File:			myDrwDlg.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   MYDRWDLG_H
#include "myDrwDlg.h"
#endif

#ifndef   MYDRWDOC_H
#include "myDrwDoc.h"
#endif

#ifndef   MYDRWNUM_H
#include "myDrwNum.h"
#endif

#ifndef   MYDRAW_K
#include "myDraw.k"
#endif

#ifndef   BRDEBUG_H
#include <BRDebug.h>
#endif

//========================================================================================
// CLASS CPenSetupDialog
//========================================================================================

//----------------------------------------------------------------------------------------
// CPenSetupDialog::CPenSetupDialog
//----------------------------------------------------------------------------------------

CPenSetupDialog::CPenSetupDialog(BR_CBureaucrat* itsSupervisor,
		BR_CView* itsEnclosure,
		const BR_CModule& itsModule,
		BR_CPen::PenThickness initialValue):
	BR_CDialogDirector(itsSupervisor, itsEnclosure, itsModule, ID_MYLINE_DIALOG)
{
	BR_CRadioGroup* theGroup = GetRadioGroup(ID_MYLINE_RADIOGROUP);
	switch (initialValue)
	{
		case 1:
			theGroup->ChangeStation(ID_LINE_1_BUTTON);
			break;
		
		case 2:
			theGroup->ChangeStation(ID_LINE_2_BUTTON);
			break;
		
		case 3:
			theGroup->ChangeStation(ID_LINE_3_BUTTON);
			break;
			
		default:
			theGroup->ChangeStation(ID_LINE_4_BUTTON);
			break;
			
	}
	((CPenSizeField*)GetSubview(ID_MYLINE_VALUE))->SetValue(initialValue);
	CenterDialog();
}

//----------------------------------------------------------------------------------------
// CPenSetupDialog::~CPenSetupDialog
//----------------------------------------------------------------------------------------

CPenSetupDialog::~CPenSetupDialog()
{
}

//----------------------------------------------------------------------------------------
//  CPenSetupDialog::CloseDialog
//----------------------------------------------------------------------------------------

BR_Boolean CPenSetupDialog::CloseDialog(BR_Boolean isCommandOK)
{
	BR_Boolean result = BR_CDialogDirector::CloseDialog(isCommandOK);
	if (result && isCommandOK)
	{
		BR_CPen::PenThickness newThickness;
		
		switch (GetRadioGroup(ID_MYLINE_RADIOGROUP)->GetStation()->GetViewId())
		{
			case ID_LINE_1_BUTTON:
				newThickness = 1;
				break;

			case ID_LINE_2_BUTTON:
				newThickness = 2;
				break;

			case ID_LINE_3_BUTTON:
				newThickness = 3;
				break;

			case ID_LINE_4_BUTTON:
			{
				newThickness = ((CPenSizeField*)GetSubview(ID_MYLINE_VALUE))->GetValue();
				break;
			}
			default:
				Assert(FALSE);
		}
		((CMyDrawDocument*)GetDocument())->SetPenThickness(newThickness);
	}
	return result;
}

//----------------------------------------------------------------------------------------
//  CPenSetupDialog::DoCommand
//----------------------------------------------------------------------------------------

BR_Boolean CPenSetupDialog::DoCommand(BR_CBureaucrat::CommandId commandId, 
	BR_CObject* notifier, BR_Boolean callSupervisor)
{	
	switch (commandId)
	{
		case ID_MYLINE_VALUE:
		{
			// if user typed into number field, change the radio station to the correct station.
			// (if not already correctly set)
			
			BR_CRadioGroup* theGroup = GetRadioGroup(ID_MYLINE_RADIOGROUP);
			
			if (theGroup->GetStation()->GetViewId() != ID_LINE_4_BUTTON)
				theGroup->ChangeStation(ID_LINE_4_BUTTON);

			break;
		}
		default:
			return (BR_CDialogDirector::DoCommand(commandId, notifier, callSupervisor));
	}
	return (TRUE);
}
