#ifndef MYDRWAPP_H
#define MYDRWAPP_H

//========================================================================================
//
//     File:			myDrwApp.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRAPPLIC_H
#include <BRApplic.h>
#endif

#ifndef   BRBUREAU_H
#include <BRBureau.h>
#endif

#ifndef   BRSTDDEF_H
#include <BRStdDef.h>
#endif

#ifndef   BRSTRING_H
#include <BRString.h>
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CDocument;
class BR_CEventLoopContext;
class BR_CFileSpec;
class BR_CObjectResource;
class BR_CMenuBar;
class BR_CSystem;
class BR_CObject;

//========================================================================================
//	CLASS CMyDrawApplication
//========================================================================================

class CMyDrawApplication : public BR_CApplication
{
public:

	// Constructor/Destructor
	CMyDrawApplication(BR_CSystem* system);
	virtual ~CMyDrawApplication();
				
	// Document operations
	virtual BR_CDocument* CreateDocument();
	virtual	BR_CDocument* OpenDocument(BR_CFileSpec& fileSpec);
	
	// Resource Operations
    virtual BR_CObject* CreateObjectFromResource(BR_CObjectResource& objectResource,
									BR_Boolean callSupervisor = TRUE) const;
	
	// Menu operations		
    virtual void UpdateMenus(BR_CMenuBar& menuBar,
									BR_Boolean callSupervisor = TRUE);
	// Command operations
    virtual BR_Boolean DoCommand(CommandId commandId,
									BR_CObject* notifier,
									BR_Boolean callSupervisor = TRUE);
	virtual void RunAboutDialog();
									
	// Event operations
	void ProcessEventsUntilContextChangesIntercept(BR_CEventLoopContext& currentContext);

};

#endif
