//========================================================================================
//
//     File:			myDrwApp.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   MYDRWAPP_H
#include "myDrwApp.h"
#endif

#ifndef   MYDRAW_K
#include "myDraw.k"
#endif

#ifndef   MYDRWDOC_H
#include "myDrwDoc.h"
#endif

#ifndef   MYDRWNUM_H
#include "myDrwNum.h"
#endif

#ifndef   MYDRWMOU_H
#include "myDrwMou.h"
#endif

#ifndef   MYDRWVW_H
#include "myDrwVw.h"
#endif

#ifndef   BRDLGDIR_H
#include <BRDlgDir.h>
#endif

#ifndef   BRMODULE_H
#include <BRModule.h>
#endif

//========================================================================================
// CLASS CMyDrawApplication
//========================================================================================

//----------------------------------------------------------------------------------------
// CMyDrawApplication::CMyDrawApplication
//----------------------------------------------------------------------------------------

CMyDrawApplication::CMyDrawApplication(BR_CSystem* system) :
			BR_CApplication(system, NULL /*module*/, IDS_APPNAME)
{
}

//----------------------------------------------------------------------------------------
// CMyDrawApplication::CMyDrawApplication
//----------------------------------------------------------------------------------------

CMyDrawApplication::~CMyDrawApplication()
{
}

//----------------------------------------------------------------------------------------
// CMyDrawApplication::CreateDocument
//----------------------------------------------------------------------------------------

BR_CDocument* CMyDrawApplication::CreateDocument()
{	
	CMyDrawDocument* drawDocument = new CMyDrawDocument(this);
	drawDocument->NewWindow();
	return (drawDocument);
}

//----------------------------------------------------------------------------------------
// CMyDrawApplication::CreateObjectFromResource
//----------------------------------------------------------------------------------------

BR_CObject* CMyDrawApplication::CreateObjectFromResource(BR_CObjectResource& objectResource, BR_Boolean callSupervisor) const
{
    IsThisViewClass(CMyDrawView,	objectResource);
    IsThisViewClass(CPenSizeField,	objectResource);

    return (BR_CApplication::CreateObjectFromResource(objectResource, callSupervisor));
}

//----------------------------------------------------------------------------------------
// CMyDrawApplication::DoCommand
//----------------------------------------------------------------------------------------

BR_Boolean CMyDrawApplication::DoCommand(BR_CBureaucrat::CommandId commandId, 
	BR_CObject* notifier, BR_Boolean callSupervisor)
{
	switch (commandId)
	{
		case cmdAbout:
			RunAboutDialog();
			break;
			
		default:
			return (BR_CApplication::DoCommand(commandId, notifier, callSupervisor));
	}
	return (TRUE);
}

//----------------------------------------------------------------------------------------
// CMyDrawApplication::OpenDocument
//----------------------------------------------------------------------------------------

BR_CDocument* CMyDrawApplication::OpenDocument(BR_CFileSpec& fileSpec)
{
	CMyDrawDocument* drawDocument = new CMyDrawDocument(this);
	drawDocument->NewWindow();
	
	// Open the file for this document.
	drawDocument->OpenFile(fileSpec);

	// Show the document window.
	drawDocument->GetWindow(0)->Show();

	return (drawDocument);
}

//----------------------------------------------------------------------------------------
// CMyDrawApplication::ProcessEventsUntilContextChangesIntercept
//----------------------------------------------------------------------------------------

void CMyDrawApplication::ProcessEventsUntilContextChangesIntercept(BR_CEventLoopContext& currentContext)
{
	// This override catches exceptions.
	BR_TRY
	{
		BR_CApplication::ProcessEventsUntilContextChangesIntercept(currentContext);
	}
	BR_CATCH_BEGIN
	BR_CATCH_NO_INSTANCE(XDrawObjectTooSmall)
	{
		// Just continue running. Take no action.
	}
	BR_CATCH_END
}

//----------------------------------------------------------------------------------------
// CMyDrawApplication::RunAboutDialog
//----------------------------------------------------------------------------------------

void CMyDrawApplication::RunAboutDialog()
{
	BR_CDialogDirector aboutDialog(this, GetAppDesktop(), *this, ID_MYDRAW_ABOUTBOX);
	aboutDialog.ShowDialog();
}

//----------------------------------------------------------------------------------------
// CMyDrawApplication::UpdateMenus
//----------------------------------------------------------------------------------------

void CMyDrawApplication::UpdateMenus(BR_CMenuBar& menuBar, BR_Boolean callSupervisor)
{
	BR_CApplication::UpdateMenus(menuBar, callSupervisor);
	menuBar.EnableCmd(cmdAbout);
}
