#ifndef MYDRAW_R
#define MYDRAW_R

//========================================================================================
//
//     File:			myDraw.r
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#define NOMINMAX

#ifndef   SKIPINCL_R
#include "SkipIncl.r"
#endif

#ifndef   MYDRAW_K
#include "myDraw.k"
#endif

#ifndef   BRTYPES_H
#include <BRTypes.h>
#endif

//========================================================================================
// Custom View Resource Types
//========================================================================================

//----------------------------------------------------------------------------------------
// TYPE RMyDrawView
//----------------------------------------------------------------------------------------

type RMyDrawView : BR_RView(ids="CMyDrawView")
{
};

//----------------------------------------------------------------------------------------
// TYPE RPenSizeField
//----------------------------------------------------------------------------------------

type RPenSizeField : BR_RNumberField(ids="CPenSizeField")
{
};

#define PenSizeField(id, X, Y, width, height)		\
	RPenSizeField(kEnclosureUnits, id, 0, {width, height, X, Y}, NULL, NULL, kRGBWindow, kIBeamCursor, TRUE),{}

//========================================================================================
// Multi-string lists
//========================================================================================

resource MULTISTRING UNIT_STRINGS
{
    1, "-pixel";
    2, "/10 mm";
    3, "/100 mm";
    4, "/10 in";
    5, "/100 in";
    6, "/20 pt";
    7, "-point";
    8, "-unit";
}

resource MULTISTRING UNDO_STRINGS
{
    1, "Line";
    2, "Rectangle";
    3, "Ellipse";
    4, "Round Rectangle";
}

//========================================================================================
// Cursors
//========================================================================================

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// Windows
//----------------------------------------------------------------------------------------

resource CURSOR IDS_APPNAME, "myDraw.cur";
#endif

//========================================================================================
// Icons
//========================================================================================

#ifdef BR_BUILD_MAC

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------

#pragma native begin
#include "myDrwIco.r"
#pragma native end

#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// Windows
//----------------------------------------------------------------------------------------

resource ICON   IDS_APPNAME, "myDraw.ico";
#endif

//========================================================================================
// Menus
//========================================================================================

#ifdef BR_BUILD_MAC

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------

resource bclmenu IDS_APPNAME
BEGIN
	BR_MenuBar
	{
		BR_AppleMenu()
		{
			{BR_MenuItem(cmdAbout,"About MyDraw")}
		},

		BR_TextMenu("File")
		{
			{BR_MenuItem(cmdNew, "New/N")},
			{BR_MenuItem(cmdOpen,"Open/O")}
				{BR_MenuItemSeparator}
			{BR_MenuItem(cmdClose,"Close/W")}
			{BR_MenuItem(cmdSave,"Save/S")}
			{BR_MenuItem(cmdSaveAs,"Save As")}
			{BR_MenuItem(cmdRevert,"Revert")}
				{BR_MenuItemSeparator}
			{BR_MenuItem(cmdPrinterPrintSetup,"Page Setup")}
			{BR_MenuItem(cmdPrint,"Print/P")}
				{BR_MenuItemSeparator}
			{BR_MenuItem(cmdQuit,"Quit/Q")}
		},
	  
		BR_TextMenu("Edit")
		{
			{BR_MenuItem(cmdUndo,"Undo/Z")}
				{BR_MenuItemSeparator}
			{BR_MenuItem(cmdCut,"Cut/X")}
			{BR_MenuItem(cmdCopy,"Copy/C")}
			{BR_MenuItem(cmdPaste,"Paste/V")}
			{BR_MenuItem(cmdClear,"Clear")}
				{BR_MenuItemSeparator}
			{BR_MenuItem(cmdSelectAll,"Select All/A")}
			{BR_MenuItem(cmdClipboard,"Show Clipboard")}
		},
	  
		BR_TextMenu("Tool")
		{
			{BR_MenuItem(cmdSelect,"Select")}
				{BR_MenuItemSeparator}
			{BR_MenuItem(cmdLine,"Line")}
			{BR_MenuItem(cmdRect,"Rectangle")}
			{BR_MenuItem(cmdEllipse,"Ellipse")}
			{BR_MenuItem(cmdRRect,"Round Rectangle")}
		},
	  
		BR_TextMenu("Draw")
		{
			{BR_MenuItem(cmdRedraw,"Redraw/R")}
				{BR_MenuItemSeparator}
			{BR_MenuItem(cmdPenSize1,"1/1")}
			{BR_MenuItem(cmdPenSize2,"2/2")}
			{BR_MenuItem(cmdPenSize3,"3/3")}
				{BR_MenuItemSeparator}
			{BR_MenuItem(cmdPenSetup,"Pen Setup/4")}
		}
	}
END;   

resource bclmenu IDS_WINDOWMENU
BEGIN
	BR_WindowMenu()
	{
	}
END;

resource bclmenu IDS_HELPMENU
BEGIN
	BR_HelpMenu()
	{
	}
END;
#endif

//----------------------------------------------------------------------------------------
// Windows
//----------------------------------------------------------------------------------------

#ifdef BR_BUILD_WIN
resource STRTABLE
{
	IDS_APPTITLE, "MyDraw 9";
}

resource bclmenu IDS_APPNAME
BEGIN
   BR_MenuBar
   {
      BR_TextMenu("~File")
      {
          {BR_MenuItem(cmdNew,"~New\tCtrl+N")},
          {BR_MenuItem(cmdOpen,"~Open...\tCtrl+O")},
          {BR_MenuItemSeparator},
          {BR_MenuItem(cmdClose,"~Close")},
          {BR_MenuItem(cmdSave,"~Save\tCtrl+S")},
          {BR_MenuItem(cmdSaveAs,"Save As...")},
          {BR_MenuItem(cmdRevert,"~Revert")},
          {BR_MenuItemSeparator},
//          {BR_MenuItem(cmdPrinterPrintSetup,"Print Setup...")},
          {BR_MenuItem(cmdPrint,"~Print...\tCtrl+P")},
          {BR_MenuItemSeparator},
          {BR_MenuItem(cmdQuit,"E~xit\tAlt+X")}
      },
      BR_TextMenu("~Edit")
      {
          {BR_MenuItem(cmdUndo,"~Undo")},
          {BR_MenuItemSeparator},
          {BR_MenuItem(cmdCut,"Cu~t")},
          {BR_MenuItem(cmdCopy,"~Copy")},
          {BR_MenuItem(cmdPaste,"Past~e")},
          {BR_MenuItem(cmdClear,"C~lear")},
//          {BR_MenuItem(cmdSelectAll,"Select ~All\tCtrl+A")},
          {BR_MenuItemSeparator},
          {BR_MenuItem(cmdClipboard,"Show Clipboard")}
      },
      BR_TextMenu("~Tool")
      {
		{BR_MenuItem(cmdSelect,"~Select")}
			{BR_MenuItemSeparator}
		{BR_MenuItem(cmdLine,"~Line")}
		{BR_MenuItem(cmdRect,"~Rectangle")}
		{BR_MenuItem(cmdEllipse,"~Ellipse")}
		{BR_MenuItem(cmdRRect,"R~ound Rectangle")}
      },
      BR_TextMenu("~Draw")
      {
		{BR_MenuItem(cmdRedraw,"Redraw\tCtrl+R")}
			{BR_MenuItemSeparator}
		{BR_MenuItem(cmdPenSize1,"1\tCtrl+1")}
		{BR_MenuItem(cmdPenSize2,"2\tCtrl+2")}
		{BR_MenuItem(cmdPenSize3,"3\tCtrl+3")}
			{BR_MenuItemSeparator}
		{BR_MenuItem(cmdPenSetup,"Pen Setup...\tCtrl+4")}
      }
   }
};

resource bclmenu IDS_WINDOWMENU
{
	BR_WindowMenu()
	{
		{BR_MenuItem(cmdTile,"~Tile")},
		{BR_MenuItem(cmdCascade,"~Cascade")}
	}
};

resource bclmenu IDS_HELPMENU
{
	BR_HelpMenu()
	{
		{BR_MenuItem(cmdHelpIndex,"~Index")},
		{BR_MenuItem(cmdHelpCmd,"~Commands")},
		{BR_MenuItem(cmdHelpProc,"~Procedures")}
		{BR_MenuItemSeparator},
		{BR_MenuItem(cmdAbout,"About MyDraw...")}
	}
};

resource ACCELTABLE IDS_APPLICATION
{
	BEDVK_DELETE, 	cmdClear, 		BEDAT_VIRTUALKEY;
//	'A', 			cmdSelectAll, 	BEDAT_CONTROL | BEDAT_CHAR;
	'N', 			cmdNew,     	BEDAT_CONTROL | BEDAT_CHAR;
	'O', 			cmdOpen, 	    BEDAT_CONTROL | BEDAT_CHAR;
	'S', 			cmdSave, 	    BEDAT_CONTROL | BEDAT_CHAR;
	'P', 			cmdPrint, 	    BEDAT_CONTROL | BEDAT_CHAR;
	'P', 			cmdQuit, 	    BEDAT_ALT     | BEDAT_CHAR;
}

#endif

//========================================================================================
// Views
//========================================================================================

resource bclview ID_MYDRAW_ABOUTBOX
{
	BR_DialogBox("About myDraw", kModalDialog, 50, 50, 180 * 64, 82 * 64)
	{
		BR_DialogPane(0)
		{
#ifdef BR_BUILD_MAC
			BR_Icon (-1, 0, 10 * 64, 10 * 64, ID_MYDRAW_APP_ICON);
#endif
#ifdef BR_BUILD_WIN
			BR_Icon (-1, 0, 10 * 64, 10 * 64, IDS_APPNAME);
#endif
			BR_Text (-1, 0, 40 * 64, 12 * 64, "myDraw do-it-yourself application");
			BR_Text (-1, 0, 40 * 64, 32 * 64, "");
			BR_Text (-1, 0, 10 * 64, 60 * 64, "Copyright 1992-1993 by Symantec Corporation");
   			BR_DefPushButton(cmdOk, 110 * 64, 30 * 64, 40 * 64, 10 * 64, "OK");
		}
	}
};

resource bclview ID_MYLINE_DIALOG
{
	BR_DialogBox("Pen Setup", kModalDialog, 50, 50, 120 * 64, 100 * 64)
	{
		BR_DialogPane(0)
		{
			BR_RadioGroup(ID_MYLINE_RADIOGROUP, "Pen Sizes", 10 * 64, 5 * 64, 100 * 64, 70 * 64)
			{
				BR_RadioButton(ID_LINE_1_BUTTON, 15 * 64, 15 * 64, 32 * 64, 12 * 64,"1-pixel"),
				BR_RadioButton(ID_LINE_2_BUTTON, 15 * 64, 27 * 64, 32 * 64, 12 * 64,"2-pixel"),
				BR_RadioButton(ID_LINE_3_BUTTON, 15 * 64, 39 * 64, 32 * 64, 12 * 64,"3-pixel"),
				BR_RadioButton(ID_LINE_4_BUTTON, 15 * 64, 51 * 64, 32 * 64, 12 * 64,"Pixels:")
			}
			PenSizeField(ID_MYLINE_VALUE, 65 * 64, 57 * 64, 30 * 64, 12 * 64),		
			BR_DefPushButton(cmdOk, 15 * 64, 82 * 64, 40 * 64, 10 * 64, "OK"),
			BR_PushButton(cmdCancel, 68 * 64, 82 * 64, 40 * 64, 10 * 64, "Cancel")
		}
	}
};

resource bclview ID_MYDRAW_WINDOW
{
	BR_DocumentWindow(kPixelUnits, "Sample", kDocumentWindow, 50, 50, 300, 350, 0)
	{
		BR_Scroller(kPixelUnits, -1, 0, 0, 400, 400,
		kScrollerFitEnclosure, kScrollerFitEnclosure, kRGBWindow,
		BR_ScrollerInfoDefault(kScrollerScrollBarStyleSystem), BR_ScrollerInfoDefault(kScrollerScrollBarStyleSystem)) 
		{
			RMyDrawView(kPixelUnits, ID_MYDRAW_VIEW, 0,
			{ 400, 400, 0, 0 },
			kSizeFixed, kSizeFixed, kRGBWindow, kArrowCursor, TRUE), 
			{
			}
		}
	}
};

//========================================================================================
// Native resources
//========================================================================================

#ifdef BR_BUILD_MAC

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------
#pragma native begin

	include $$Shell("BedObjectsFolder")"bcl.res";
	include $$Shell("BedObjectsFolder")"macbcl.res";
	include $$Shell("ObjApp")"myDraw" 'CODE';

	#include "myDrwBun.r"

#pragma native end

#endif

#endif
