#ifndef EDSTATBR_H
#define EDSTATBR_H
//===================================================================================
//
//     File:			EdStatBr.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef EDRECT_H
#include "EdRect.h"
#endif

#ifndef BRSTATUS_H
#include <BRStatus.h>
#endif

#ifndef BRSTATXT_H
#include <BRStaTxt.h>
#endif

#ifndef BRDATETI_H
#include <BRDateTi.h>
#endif

//===================================================================================
// class cEdStatusBar
//
// A class derived from cStatusBar which uses a cStatusRect to display the help 
// status, current row and column, and the current time.
//===================================================================================

class cEdStatusBar : public BR_CStatusBar
{
public:
					cEdStatusBar(BR_CAppDesktop *enclosure);
	virtual			~cEdStatusBar();
					
	void			UpdateHelpString(const BR_TString<BR_Char>& helpString);
	void			UpdateColumnNumber(const BR_CStaticText::ColumnNumber columnNo);
	void			UpdateLineNumber(const BR_CStaticText::LineNumber lineNo);
	void			UpdateTime(const BR_CTime& time);

private:
	cStatusRect		*fHelpRect;    // Pointer to the Help Status rectangle
	cStatusRect		*fColumnRect;  // Pointer to the Column rectangle
	cStatusRect 	*fLineRect;	   // Pointer to the Line rectangle
	cStatusRect 	*fTimeRect;	   // Pointer to the Time rectangle

					BR_SETCLASSNAME(cEdStatusBar);
};

#endif
