//===================================================================================
//
//     File:			EdRect.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef EDAPP_H
#include "EdApp.h"
#endif

#ifndef EDRECT_H
#include "EdRect.h"
#endif

#ifndef EDSTATBR_H
#include "EdStatBr.h"
#endif

#ifndef BRCANVAS_H
#include <BRCanvas.h>
#endif

#ifndef BRVIEW_H
#include <BRView.h>
#endif

DEFINE_CLASS(cStatusRect, BR_CView);

//-----------------------------------------------------------------------------------
// cStatusRect::cStatusRect
//
// This class creates a rectangle on the Status Bar to draw text into.
//-----------------------------------------------------------------------------------

cStatusRect::cStatusRect(BR_CView			*enclosure,
						 BR_CBureaucrat		*supervisor,
						 ViewId				viewId,
						 BR_Distance		width,
						 BR_Distance		height,
						 BR_Coordinate		x,
						 BR_Coordinate		y)	
			:BR_CView(enclosure,
					  supervisor,
					  viewId,
					  kEnclosureUnits,
					  -1,
					  width,
					  height,
					  x,
					  y,
					  kNoSizing,
					  kNoSizing,
					  kRGBTransparent)
{
}

//-----------------------------------------------------------------------------------
// cStatusRect::~cStatusRect
//
// The destructor for the cStatusRect class.
//-----------------------------------------------------------------------------------

cStatusRect::~cStatusRect()
{
}

//-----------------------------------------------------------------------------------
// cStatusRect::Draw
//
// Draws the rectangle on the status bar
//-----------------------------------------------------------------------------------

void cStatusRect::Draw(BR_CView &view)
{
	// Draw the text in the rectangle
	DrawText(view);
}

//-----------------------------------------------------------------------------------
// cStatusRect::DrawText
//
// Draw the text in a cStatusRect
//-----------------------------------------------------------------------------------

void cStatusRect::DrawText(BR_CView &view)
{
	BR_CRectangle boundsRect;
	BR_CColor rectColor(kRGBLightGray);
	BR_CPen grayPen(kRGBDarkGray);
	GetFrame(boundsRect);

	// Make sure the text doesn't overwrite the border
	boundsRect.Set(boundsRect.fLeft + 3, boundsRect.fTop + 2,
				   boundsRect.fRight - 3, boundsRect.fBottom - 2);

	// Erase the rectangle contents
	{
		BR_CGraphicsToolSelector penSelector(&view, &grayPen);
		BR_CDrawInitiator drawInit(&view);
		view.GetCanvas()->DrawRectangle(boundsRect, rectColor);
	}
	
	// Draw the new text
	view.GetCanvas()->DrawText(boundsRect, fRectText, BEDDT_LEFT);
}

//-----------------------------------------------------------------------------------
//  cStatusRect::SetText
//
//  Sets the text for the cStatusRect
//-----------------------------------------------------------------------------------

void cStatusRect::SetText(const BR_TString<BR_Char> &textStr)
{
	fRectText = textStr;

	BR_CView &view = *((cEditApp*)GetApplication())->GetStatusBar();
	DrawText(view);
}
