//===================================================================================
//
//     File:			EdDoc.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef EDITTEXT_H
#include "EditText.h"
#endif

#ifndef EDDOC_H
#include "EdDoc.h"
#endif

#ifndef BRMNUBAR_H
#include <BRMnuBar.h>
#endif

#ifndef BRAPPLIC_H
#include <BRApplic.h>
#endif

#ifndef BRMDIDES_H
#include <BRMdides.h>
#endif

#ifndef BRCONDLG_H
#include <BRCondlg.h>
#endif

#ifndef BRDOCWIN_H
#include <BRDocWin.h>
#endif

#ifndef BRSCROLL_H
#include <BRScroll.h>
#endif

#ifndef BRCMDIDS_H
#include <BRCmdIds.h>
#endif

#ifndef BRFONTCH_H
#include <BRFontCh.h>
#endif

#ifndef BRFILE_H
#include <BRFile.h>
#endif

DEFINE_CLASS(cEditDoc, BR_CDocument);

//-----------------------------------------------------------------------------------
//	cEditDoc::cEditDoc
//-----------------------------------------------------------------------------------

cEditDoc::cEditDoc(BR_CApplication *application) :
	BR_CDocument(application, TRUE),
	fEdEditText(NULL),
	fTextStream(NULL)
{
}

//-----------------------------------------------------------------------------------
//	cEditDoc::~cEditDoc
//-----------------------------------------------------------------------------------

cEditDoc::~cEditDoc()
{
}

//-----------------------------------------------------------------------------------
// cEditDoc::NewWindow
//
// Creates a new cEdEditText window.
//-----------------------------------------------------------------------------------

void cEditDoc::NewWindow()
{
   	BR_CMDIAppDesktop *desktop = (BR_CMDIAppDesktop *)(GetApplication()->GetAppDesktop());
	BR_CDocWindow *window = new BR_CDocWindow(desktop, this);
	BR_SScrollerInfo scrollerInfo(kScrollerScrollBarStyleSystem);
	BR_CScroller *scroller = new BR_CScroller(window,
											  this,
											  1000,
											  kPixelUnits,
											  -1,
											  0,
											  0,
											  0,
											  0,
											  kScrollerFitEnclosure,
											  kScrollerFitEnclosure,
											  kRGBWindow,
											  scrollerInfo,
											  scrollerInfo);

	// Create an EditText with the scroller as its enclosure
	fEdEditText = new cEdEditText(scroller, this,
								  0, 0, 0, 0,
                                  kFitEnclosure,
								  kFitEnclosure,
								  kEnclosureUnits,
								  BR_CRectangle(0,0,2000,2000));

	// Create a 32K TextStream and connect it up
	fTextStream = new BR_CTextStream((BR_CStream::StreamSize)32000);
	fEdEditText->SetTextStream(fTextStream);
}

//-----------------------------------------------------------------------------------
// cEditDoc::DoSave
//
// Save the current editor contents to a text file
//-----------------------------------------------------------------------------------

BR_Boolean cEditDoc::DoSave()
{
	BR_CTextStream *textStream = fEdEditText->GetTextStream();
	BR_CFileStream *fileStream = GetFileStream();
	BR_Boolean isSaved = textStream->Save(*fileStream);
	SetDirty(isSaved);
	return isSaved;
}

//-----------------------------------------------------------------------------------
// cEditDoc::DoSaveAs
//
// Save the text to a new file name.
//-----------------------------------------------------------------------------------

BR_Boolean cEditDoc::DoSaveAs(const BR_CFileSpecification& fileSpec) 
{
	// Save the current file stream
	BR_CFileStream* oldFileStream = GetFileStream();
	
	// Create a new file stream
	SetFileStream(BR_NEW(BR_CFileStream, (fileSpec)));
	
	// Save to the new, current file stream
	BR_Boolean isSaved;
	BR_TRY
	{
		isSaved = DoSave();
	}
	BR_CATCH_BEGIN
	BR_CATCH_EVERYTHING()
	{
		// An error occurred...
		// Delete the new file stream and restore the old file stream
		delete GetFileStream();
		SetFileStream(oldFileStream);
		BR_THROW_SAME();
	}
	BR_CATCH_END
	
	return isSaved;
}

//-----------------------------------------------------------------------------------
// cEditDoc::DoRevert
//
// Reloads the text file from disk and discards any changes made to the copy in memory.
//-----------------------------------------------------------------------------------

void cEditDoc::DoRevert()
{
	BR_CConfirmRevert revertDlg(this);

	if(revertDlg.GetResult() == IDYES)
	{
		// Reload the file stream into the textedit stream
		BR_CTextStream* textStream = fEdEditText->GetTextStream();
		BR_CFileStream *fileStream = GetFileStream();
		textStream->Load(*fileStream);
		
		// Memory image matches the one on disk, so clear the dirty bit
		SetDirty(FALSE);
	}
}

//-----------------------------------------------------------------------------------
// cEditDoc::UpdateMenus
//
// Called to activate menu options
//-----------------------------------------------------------------------------------

void cEditDoc::UpdateMenus(BR_CMenuBar &menuBar, BR_Boolean fCallSupervisor)
{
	BR_CDocument::UpdateMenus(menuBar, fCallSupervisor);

	// Check whether document is modifiable, and if it's been changed since
	// it was last saved.
	if(!fEdEditText->IsReadOnly() && IsDirty())
	{
		menuBar.EnableCmd(cmdSave);
		
		// Is there a file associated with this document?
		if (GetFileStream() != NULL)
			menuBar.EnableCmd(cmdRevert);
	}
	
	menuBar.EnableCmd(cmdPrint);
	menuBar.EnableCmd(cmdDocumentPrintSetup);
	menuBar.EnableCmd(cmdPrinterPrintSetup);
}

//-----------------------------------------------------------------------------------
// cEditDoc::DoCommand
//
// Called to process command options
//-----------------------------------------------------------------------------------

BR_Boolean cEditDoc::DoCommand(unsigned short cmdId,
							   BR_CObject *notifier,
							   BR_Boolean fCallSupervisor)
{
   BR_Boolean commandHandled = TRUE;				// Return value

	switch (cmdId)
	{
		case cmdRevert:
			DoRevert();
			break;
			
		case cmdPrinterPrintSetup:
			DoPrinterPrintSetup();
			break;
			
		default:
        	commandHandled = BR_CDocument::DoCommand(cmdId,
													 notifier,
													 fCallSupervisor);
	}
	return (commandHandled);
}
