#if defined(BR_DEBUG) && defined(BR_BUILD_WIN) && !defined(BRWTRACE_H)
#define BRWTRACE_H
// This entire file is for debugging Windows applications only
//========================================================================================
//
//	File:				BRWTrace.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		12/14/92
//
//	COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//	RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//	PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//	THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//	CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//	EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//	RESTRICTED RIGHTS LEGEND
//	Use, duplication, or disclosure by the Government is subject to restrictions as set
//	forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//	Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//	Cupertino, CA 95014.
//
//========================================================================================

#ifndef _INC_WINDOWS
#include <Windows.h>
#endif

#ifdef __cplusplus 
extern "C" {
#endif

	void FAR PASCAL BR_BedWinGetCallerInfo(HANDLE* phModule,
									 char* zModule,
									 WORD* pwSegment,
									 WORD* pwOffset,
									 unsigned n_TraceDepth);
		// Crawls the stack and returns caller info as follows: *phModule is the Windows
		// module handle, zModule (if not NULL) receives the name, *pwSegment is the
		// ordinal segment number and pwOffset is the offset within that segment.
		// n_TraceDepth specifies how far to crawl.
		
	void FAR PASCAL BR_BedWinGetModuleName(HANDLE hModule,
									 char* zModule);
		// Returns name of a Windows module identified by handle hModule.
		// Module names do not exceed 8 characters.

#ifdef __cplusplus 
}
#endif
	  
#endif
