/*========================================================================================
/ 
/      File:			BRWLibra.h
/      Release Version:	$ 1.0d1 $
/ 
/      Creation Date:	November 29, 1990
/ 
/      COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/ 
/      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/ 
/      RESTRICTED RIGHTS LEGEND
/      Use, duplication, or disclosure by the Government is subject to restrictions as Set
/      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/      Cupertino, CA 95014.
/ 
/=======================================================================================*/

#ifdef BR_BUILD_WIN

#ifndef BRWLIBRA_H
#define BRWLIBRA_H

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifdef __cplusplus
    extern "C" {
#endif


typedef struct BR_SFileFindBuffer {    /* for BR_FileFindFirst / BR_FileFindNext */
	char fReserved[21];
	char fAttribute;
	unsigned fFileFindTime;
	unsigned fFileFindDate;
	long size;
	char name[13];
	} BR_SFileFindBuffer, FAR * BR_SFileFindBufferPtr;

typedef struct BR_SDosFileError {
	unsigned short	fError;
	unsigned char	class;
	unsigned char	action;
	unsigned char	locus;
	} BR_SDosFileError, FAR * BR_SDosFileErrorPtr;


BR_EXPORTENTRY(void) BR_FileRemove (char _far * filename);

BR_EXPORTENTRY(unsigned short) BR_FileFindFirst (
	const char _far * pathname,
	unsigned short fAttribute,
	BR_SFileFindBufferPtr findbuf);
	
BR_EXPORTENTRY(unsigned short) BR_FileFindNext (BR_SFileFindBufferPtr findbuf);

BR_EXPORTENTRY(unsigned long) BR_FileReadHuge  (
	unsigned short file,
	char _huge * buffer,
	unsigned long size);

BR_EXPORTENTRY(unsigned long) BR_FileWriteHuge (
	unsigned short file,
	char _huge * buffer,
	unsigned long size);

BR_EXPORTENTRY(unsigned short) BR_DosGetExtendedError (BR_SDosFileErrorPtr errInfo);

#ifdef __cplusplus
    }
#endif

#endif

#endif
