/*========================================================================================
/ 
/      File:		BRStr.h
/      Release Version:	$ 1.0d1 $
/ 
/      Creation Date:	November 4, 1989
/ 
/      COPYRIGHT 1989-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/ 
/      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/ 
/      RESTRICTED RIGHTS LEGEND
/      Use, duplication, or disclosure by the Government is subject to restrictions as Set
/      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/      Cupertino, CA 95014.
/ 
/=======================================================================================*/

/*--------------------------------------------------------------------------------------
//	This file is part of the old international implementation.
//	The Bedrock team is in the process of designing a totally new approach.
//	For more details on the new approach please look in the 
//	":BEDROCK:INTL:INCLUDES:" folder.
//	The new approach departs from the close tie to characters and characterSets.
//	Instead it bases all internationalization efforts on locale based
//	characters, and character sets, with Unicode as the central set.
/--------------------------------------------------------------------------------------*/


#ifndef BRSTR_H
#define BRSTR_H

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifdef __cplusplus
  extern "C" {
#endif



#define BR_BEDSTRING_LENGTHCOUNT 2
#define BR_BEDSTRING_OVERHEAD 4

#if (BR_BEDSTRING_LENGTHCOUNT == 2)
#define BR_BEDSTRING_SETCOUNT(string,cnt) {*(unsigned short FAR *)(string)=(unsigned short)(cnt);}
#define BR_BEDSTRING_GETCOUNT(string) ((unsigned short)*(unsigned short FAR *)(string))
#else
#define BR_BEDSTRING_SETCOUNT(string,cnt) {*(unsigned char FAR *)(string)=(unsigned char)(cnt);}
#define BR_BEDSTRING_GETCOUNT(string) ((unsigned short)*(unsigned char FAR *)(string))
#endif

#define BR_TEXTSET_SBCS 1
#define BR_TEXTSET_DBCS 2
#define BR_TEXTSET_MBCS 3

#define BR_TEXTSET BR_TEXTSET_SBCS

#if (BR_TEXTSET == BR_TEXTSET_SBCS)
#define BR_StringByteLength(string,count) (count)
#define BR_FullStringCharacterCount(string,len) (len)
#else
#if (BR_TEXTSET == BR_TEXTSET_DBCS)
#define BR_StringByteLength(string,count) (count*2)
#define BR_FullStringCharacterCount(string,len) (len/2)
#else
/* Must be MBCS, use procedures to count */
#define BR_StringByteLength(string,count) ERROR_FUNCTION_MISSING
#define BR_FullStringCharacterCount(string,len) ERROR_FUNCTION_MISSING
#endif
#endif

typedef unsigned short BR_ParseTokenType;
typedef unsigned short BR_ParseTokenClass;
typedef BR_StringPtr BR_ParseTokenPtr;
typedef unsigned short BR_ParseTokenCount;

typedef struct BR_SParsingToken
   {
   BR_ParseTokenType fTokenType;
   BR_ParseTokenClass fTokenClass;
   BR_ParseTokenPtr fTokenPtr;
   BR_ParseTokenCount fTokenCount;
   } BR_SParsingToken, FAR * BR_SParsingTokenPtr;

typedef enum BR_ParseClass
{
	BR_ParseClass_kString,
	BR_ParseClass_kRun
} BR_ParseClass;

typedef struct BR_SParseList
   {
   BR_ParseTokenPtr fParseStr;
   BR_ParseTokenCount fParseCnt;
   BR_ParseTokenType fParseType;
   BR_ParseClass fParseClass;
   } BR_SParseList, FAR * BR_SParseListPtr;
/* String Procedures */

typedef unsigned short BS_StringLength;
/* Each of the string Copy procedures Copy str2 to str1, i.e. str1=str2; */

BR_EXPORTENTRY(char FAR *) BR_ByteMemoryMove (char FAR *  str1, char FAR *  str2, unsigned short len);
BR_EXPORTENTRY(BR_StringPtr) BR_MemoryMove	  (BR_StringPtr str1, BR_StringPtr str2, BS_StringLength cnt);

BR_EXPORTENTRY(BR_BedString) BR_CopyToBedString (BR_BedString str1, BR_StringPtr str2, BS_StringLength cnt);
BR_EXPORTENTRY(BR_AnsiString) BR_CopyToAnsiString   (BR_AnsiString   str1, BR_StringPtr str2, BS_StringLength cnt);
BR_EXPORTENTRY(BR_PascalString) BR_CopyToPascalString   (BR_PascalString   str1, BR_StringPtr str2, BS_StringLength cnt);

BR_EXPORTENTRY(BR_BedString) BR_CopyPascalStringToBedString (BR_BedString str1, BR_PascalString str2);
BR_EXPORTENTRY(BR_PascalString) BR_PascalStringCopy	      (BR_PascalString   str1, BR_PascalString str2);
BR_EXPORTENTRY(BR_AnsiString) BR_PascalStringToAnsiStringCopy   (BR_AnsiString   str1, BR_PascalString str2);

BR_EXPORTENTRY(BR_BedString) BR_AnsiStringToBedStringCopy (BR_BedString str1, BR_AnsiString str2);
BR_EXPORTENTRY(BR_AnsiString) BR_AnsiStringCopy	      (BR_AnsiString   str1, BR_AnsiString str2);
BR_EXPORTENTRY(BR_PascalString) BR_AnsiStringToPascalStringCopy   (BR_PascalString   str1, BR_AnsiString str2);

BR_EXPORTENTRY(BR_BedString) BR_ModulaStringToBedStringCopy (
	unsigned short str1Max,
	BR_BedString str1,
	unsigned short str2Max,
	BR_StringPtr str2);

BR_EXPORTENTRY(BR_BedString) BR_BedStringCopy	     (BR_BedString str1, BR_BedString str2);
BR_EXPORTENTRY(BR_PascalString) BR_BedStringToPascalStringCopy (BR_PascalString   str1, BR_BedString str2);
BR_EXPORTENTRY(BR_AnsiString) BR_BedStringToAnsiStringCopy (BR_AnsiString   str1, BR_BedString str2);

BR_EXPORTENTRY(BR_PascalString) BR_PascalStringConcatenate (BR_PascalString   str1, BR_PascalString   str2);
BR_EXPORTENTRY(BR_AnsiString) BR_AnsiStringConcatenate (BR_AnsiString   str1, BR_AnsiString   str2);
BR_EXPORTENTRY(BR_BedString) BR_BedStringConcatenate  (BR_BedString str1, BR_BedString str2);

typedef short BR_StringCompareResult;

BR_EXPORTENTRY(BR_StringCompareResult) BR_StringCompare (BR_StringPtr  str1, BS_StringLength cnt1, BR_StringPtr str2, BS_StringLength cnt2);
BR_EXPORTENTRY(BR_StringCompareResult) BR_PascalStringCompare  (BR_PascalString   str1, BR_PascalString   str2);
BR_EXPORTENTRY(BR_StringCompareResult) BR_AnsiStringCompare  (BR_AnsiString   str1, BR_AnsiString   str2);
BR_EXPORTENTRY(BR_StringCompareResult) BR_BedStringCompare   (BR_BedString str1, BR_BedString str2);

BR_EXPORTENTRY(BR_StringCompareResult) BR_StringCompareIgnoreCase (BR_StringPtr	str1, BS_StringLength cnt1, BR_StringPtr str2, BS_StringLength cnt2);
BR_EXPORTENTRY(BR_StringCompareResult) BR_BedStringCompareIgnoreCase   (BR_BedString str1, BR_BedString str2);
BR_EXPORTENTRY(BR_StringCompareResult) BR_PascalStringCompareNoCase  (BR_PascalString	str1, BR_PascalString   str2);
BR_EXPORTENTRY(BR_StringCompareResult) BR_AnsiStringCompareIgnoreCase  (BR_AnsiString	str1, BR_AnsiString   str2);

BR_EXPORTENTRY(BR_PascalString) BR_AnsiStringToPascalString   (BR_AnsiString   str1); /*C str to Pascal str*/
BR_EXPORTENTRY(BR_PascalString) BR_BedStringToPascalString	  (BR_BedString str1); /*Bedrock str to Pascal str*/
BR_EXPORTENTRY(BR_AnsiString) BR_BedStringToAnsiString	  (BR_BedString str1); /*Bedrock str to C str*/
BR_EXPORTENTRY(BR_AnsiString) BR_PascalStringToAnsiString   (BR_PascalString   str1); /*Pascal str to C str*/
BR_EXPORTENTRY(BR_BedString) BR_AnsiStringToBedString (BR_AnsiString   str1); /*C str to Bedrock str*/
BR_EXPORTENTRY(BR_BedString) BR_PascalStringToBedString (BR_PascalString   str1); /*Pascal str to Bedrock str*/

BR_EXPORTENTRY(unsigned short) BR_PascalStringByteLen  (BR_PascalString   str1);   /*Get physical length of str*/
BR_EXPORTENTRY(unsigned short) BR_AnsiStringByteLen  (BR_AnsiString   str1);
BR_EXPORTENTRY(unsigned short) BR_BedStringByteLen   (BR_BedString str);
/*BR_EXPORTENTRY(unsigned short)  BR_StringByteLength (BR_StringPtr str1, BS_StringLength cnt);*/

BR_EXPORTENTRY(BS_StringLength) BR_PascalStringCount (BR_PascalString   str1);	 /*Get character count of str*/
BR_EXPORTENTRY(BS_StringLength) BR_AnsiStringCount (BR_AnsiString   str1);
BR_EXPORTENTRY(BS_StringLength) BR_BedStringCount  (BR_BedString str);

BR_EXPORTENTRY(void) BR_SetPascalStringByteLength   (BR_PascalString   str, unsigned short len);
BR_EXPORTENTRY(void) BR_SetAnsiStringByteLength   (BR_AnsiString   str, unsigned short len);
BR_EXPORTENTRY(void) BR_SetBedStringByteLength (BR_BedString str, unsigned short len);

BR_EXPORTENTRY(void) BR_SetPascalStringCount	 (BR_PascalString   str, BS_StringLength cnt);
BR_EXPORTENTRY(void) BR_SetAnsiStringCount	 (BR_AnsiString   str, BS_StringLength cnt);
BR_EXPORTENTRY(void) BR_SetBedStringCount (BR_BedString str, BS_StringLength cnt);

/*
   These functions insert str2 into str1 at the insertnumber given replacing
   the insert marker with the str2 string. %%{number} is an insertion marker.

   Ex. str1 = "Greetings %%1, you are %%2 fYears old."
       s2a = "Robert"
       s2b = "28"
       BR_BedStringSubstitute (str1, s2a, 1);
	  result after call: str1 = "Greetings Robert, you are %%2 fYears old."
       BR_BedStringSubstitute (str1, s2b, 2);
	  result after call: str1 = "Greetings Robert, you are 28 fYears old."

   These functions should be used for ALL string insertions to allow for easy
   internationalization of the strings.
*/

BR_EXPORTENTRY(BR_StringPtr) BR_StringSubstitute (BR_StringPtr str1, BS_StringLength cnt1,
				 BR_StringPtr str2, BS_StringLength cnt2,
				 short insertnumber, BS_StringLength FAR * newcnt );
BR_EXPORTENTRY(BR_PascalString) BR_PascalStringSubstitute (BR_PascalString str1, BR_PascalString str2, short insertNumber);
BR_EXPORTENTRY(BR_AnsiString) BR_AnsiStringSubstitute (BR_AnsiString str1, BR_AnsiString str2, short insertNumber);
BR_EXPORTENTRY(BR_BedString) BR_BedStringSubstitute (BR_BedString str1, BR_BedString str2, short insertNumber);

/*
   These functions will insert string 2 into string 1 after the character
   specified by the given position pos.  To insert at the beginning of the
   string use the Value 0 for the position.
   Note C string users: the position is character position not array position,
			i.e. the first character is position 1 not 0.
*/

BR_EXPORTENTRY(BR_StringPtr) BR_StringInsert (BR_StringPtr str1, BS_StringLength cnt1,
				  BR_StringPtr str2, BS_StringLength cnt2, unsigned short pos );
BR_EXPORTENTRY(BR_PascalString) BR_PascalStringInsert (BR_PascalString str1, BR_PascalString str2, unsigned short pos);
BR_EXPORTENTRY(BR_AnsiString) BR_AnsiStringInsert (BR_AnsiString str1, BR_AnsiString str2, unsigned short pos);
BR_EXPORTENTRY(BR_BedString) BR_BedStringInsert (BR_BedString str1, BR_BedString str2, unsigned short pos);

BR_EXPORTENTRY(BR_StringPtr) BR_ConcatenateStringCharacter (BR_StringPtr str, BS_StringLength cnt, BR_StringCharacter c);
BR_EXPORTENTRY(void) BR_BedStrConcatStringCharacter (BR_BedString str, BR_StringCharacter c);

BR_EXPORTENTRY(BR_Boolean) BR_FindString (BR_StringPtr FAR * baseStr, BS_StringLength baseCnt,
			BR_StringPtr locStr, BS_StringLength locCnt, BR_Boolean flCaseSensitive);

BR_EXPORTENTRY(BR_VMHandle) BR_TokenizeFromList (BR_StringPtr str, BS_StringLength len, unsigned short FAR * count,
					BR_SParseListPtr pList, unsigned short listCount);
/* String Case operators */

BR_EXPORTENTRY(BR_PascalString) BR_PascalStringUpperCase (BR_PascalString str1);
BR_EXPORTENTRY(BR_AnsiString) BR_AnsiStringUpperCase (BR_AnsiString str1);
BR_EXPORTENTRY(BR_BedString) BR_BedStringUpperCase (BR_BedString str1);
BR_EXPORTENTRY(BR_StringPtr) BR_StringUpperCase (BR_StringPtr str1, BS_StringLength cnt);

BR_EXPORTENTRY(BR_PascalString) BR_PascalStringLowerCase (BR_PascalString str1);
BR_EXPORTENTRY(BR_AnsiString) BR_AnsiStringLowerCase (BR_AnsiString str1);
BR_EXPORTENTRY(BR_BedString) BR_BedStringLowerCase (BR_BedString str1);
BR_EXPORTENTRY(BR_StringPtr) BR_StringLowerCase (BR_StringPtr str1, BS_StringLength cnt);


/* Number conversion procedures */
BR_EXPORTENTRY(BS_StringLength) BR_NumberToString (
	long num, 
	unsigned short base,
	BR_StringPtr  s,
	unsigned short maxlen);
BR_EXPORTENTRY(BR_Boolean) BR_StringToNumber (
	BR_StringPtr  s,
	BS_StringLength characterCnt, 
	unsigned short base, 
	long FAR * num);
BR_EXPORTENTRY(BS_StringLength) BR_PositiveNumberToString (
	unsigned long num,
	unsigned short base,
	BR_StringPtr s,
	unsigned short maxlen);
BR_EXPORTENTRY(BR_Boolean) BR_StringToPositiveNumber (
	BR_StringPtr  s,
	BS_StringLength characterCnt,
	unsigned short base,
	unsigned long FAR * num);
BR_EXPORTENTRY(short) BR_StringToShort (BR_StringPtr  str1, BS_StringLength characterCnt);
BR_EXPORTENTRY(long) BR_StringToLong (BR_StringPtr  str1, BS_StringLength characterCnt);
BR_EXPORTENTRY(BS_StringLength) BR_ShortToString (BR_StringPtr str1, short maxlen, short num);
BR_EXPORTENTRY(BS_StringLength) BR_LongToString (BR_StringPtr str1, short maxlen, long num);
BR_EXPORTENTRY(BS_StringLength) BR_ShortToHexString (BR_StringPtr str1, short maxlen, short num);
BR_EXPORTENTRY(BS_StringLength) BR_LongToHexString (BR_StringPtr str1, short maxlen, long num);
BR_EXPORTENTRY(long) BR_RomanStringToLong (BR_StringPtr str1, BS_StringLength cnt);
BR_EXPORTENTRY(short) BR_RomanStringToShort (BR_StringPtr str1, BS_StringLength cnt);

BR_EXPORTENTRY(BS_StringLength) BR_LongToRomanString (
	BR_StringPtr str1,
	unsigned short maxlen,
	long num,
	BR_Boolean isUpperCase);
BR_EXPORTENTRY(BS_StringLength) BR_ShortToRomanString (
	BR_StringPtr str1,
	unsigned short maxlen,
	short num,
	BR_Boolean isUpperCase);


BR_EXPORTENTRY(short) BR_BedStringToShort (BR_BedString str1);
BR_EXPORTENTRY(long) BR_BedStringToLong (BR_BedString str1);
BR_EXPORTENTRY(BR_BedString) BR_ShortToBedString (BR_BedString str1, short num);
BR_EXPORTENTRY(BR_BedString) BR_LongToBedString (BR_BedString str1, long num);
BR_EXPORTENTRY(short) BR_RomanBedStringToShort (BR_BedString str1);
BR_EXPORTENTRY(long) BR_RomanBedStringToLong (BR_BedString str1);
BR_EXPORTENTRY(BR_BedString) BR_ShortToRomanBedString (BR_BedString str1, short num, BR_Boolean isUpperCase);
BR_EXPORTENTRY(BR_BedString) BR_LongToRomanBedString (BR_BedString str1, long num, BR_Boolean isUpperCase);
BR_EXPORTENTRY(BR_BedString) BR_ShortToHexBedString (BR_BedString str1, short num);
BR_EXPORTENTRY(BR_BedString) BR_LongToHexBedString (BR_BedString str1, long num);

#ifdef BR_BUILD_PM
BR_EXPORTENTRY(short) BedGetStrResource (HBEDANCHOR hab, unsigned long myType, unsigned long id,
						unsigned short maxSize, BR_BedString text);
#endif


#ifdef __cplusplus
   }
#endif

#endif
