/*========================================================================================
/ 
/      File:		BRIntl.h
/      Release Version:	$ 1.0d1 $
/ 
/      Creation Date:	November 3, 1989
/ 
/      COPYRIGHT 1989-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/ 
/      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/ 
/      RESTRICTED RIGHTS LEGEND
/      Use, duplication, or disclosure by the Government is subject to restrictions as Set
/      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/      Cupertino, CA 95014.
/ 
/=======================================================================================*/



/*--------------------------------------------------------------------------------------
//	This file is part of the old international implementation.
//	The Bedrock team is in the process of designing a totally new approach.
//	For more details on the new approach please look in the 
//	":BEDROCK:INTL:INCLUDES:" folder.
//	The new approach departs from the close tie to characters and characterSets.
//	Instead it bases all internationalization efforts on locale based
//	characters, and character sets, with Unicode as the central set.
/--------------------------------------------------------------------------------------*/

#ifndef BRINTL_H
#define BRINTL_H

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef BRSTR_H
#include "BRStr.h"
#endif

#ifndef BRTIME_H
#include "BRTime.h"
#endif

#ifdef __cplusplus
  extern "C" {
#endif

/* The following are defines to the Unicode Character Set */
typedef enum BR_UniCode
{
	BR_UniCode_kSpace	= 32,
	BR_UniCode_kMinus	= 45,
	BR_UniCode_kNumber0 = 48,
	BR_UniCode_kNumber9 = 57,
	BR_UniCode_kUpperLatinLetterA = 65,
	BR_UniCode_kUpperLatinLetterZ = 90,
	BR_UniCode_kLowerLatinLetterA = 97,
	BR_UniCode_kLowerLatinLetterZ =122
} BR_UniCode;

typedef enum BR_CharacterSetId
   {
	BR_CharacterSetId_kCharacterSetIdCurrent,
	BR_CharacterSetId_kCharacterSetIdUnicode
	} BR_CharacterSetId;
/*
   Any field that is unknown in a given environment is defaulted to the
   best guess based upon the fCountry code.  Where the fCountry code is not
   available or unknown, the United States defaults are used!
*/

/* Error code for BR_CompareStrings */

typedef enum BR_CompareErrors
{
	BR_CompareErrors_kError = 32767
} BR_CompareErrors;

typedef enum {BR_CharacterSetTypes_kSBCS, BR_CharacterSetTypes_kMBCS, BR_CharacterSetTypes_kDBCS, BR_CharacterSetTypes_kJIS} BR_CharacterSetTypes;
typedef enum 
	{
	BR_TextDirections_kLeftToRight,
	BR_TextDirections_kRightToLeft,
	BR_TextDirections_kTopLeftToBottom,
	BR_TextDirections_kTopRightToBottom
	} BR_TextDirections;

#define BR_DATETIME_DAYSINWEEK 10

typedef struct BR_SDateTimeNames
{
	BR_BedString fDaysOfWeek[BR_DATETIME_DAYSINWEEK];
	BR_BedString fAbbrDaysOfWeek[BR_DATETIME_DAYSINWEEK];
	BR_BedString fMonths[14];
	BR_BedString fAbbrMonths[14];
	BR_BedString fYears[12];
	BR_BedString fMorning;
	BR_BedString fEvening;
	BR_BedString fMilitary;
} BR_SDateTimeNames, FAR* BR_SDateTimeNamesPtr;

typedef short BR_FormattingWidth;

typedef unsigned long BR_FloatFormatOptions;

#define BR_FltFmt_kUseDefault				(0x00000001L)
#define BR_FltFmt_kUseFieldWidthFiller		(0x00000002L)
#define BR_FltFmt_kForceDigitBeforeDecimal	(0x00000004L)
#define BR_FltFmt_kUseScientificNotation	(0x00000008L)
#define BR_FltFmt_kRightJustify				(0x00000010L)
#define BR_FltFmt_kTruncateNumber			(0x00000020L)

typedef struct BR_SFloatFormat
{
	BR_BedString fDecimalSeparator;
	BR_BedString fThousandsSeparator;
	short fThousandsSeparatorPosition;
	BR_BedString fOverflowString;
	BR_BedString fFieldWidthFiller;
	BR_BedString fPositivePattern;					/*%%F%%#*/
	BR_BedString fNegativePattern;							/*%%F-%%#*/
	BR_FloatFormatOptions fOptions;
} BR_SFloatFormat, FAR* BR_SFloatFormatPtr;


typedef unsigned long BR_IntegerFormatOptions;
	
#define BR_IntFmt_kUseDefault				(0x00000001L)
#define BR_IntFmt_kUseFieldWidthFiller		(0x00000002L)
#define BR_IntFmt_kForceDigit				(0x00000004L)
#define BR_IntFmt_kRightJustify				(0x00000008L)

typedef struct BR_SIntegerFormat
{
	short fRadix;
	BR_BedString fThousandsSeparator;
	short fThousandsSeparatorPosition;
	BR_BedString fOverflowString;
	BR_BedString fFieldWidthFiller;
	BR_BedString fPositivePattern;					/*%%F%%#*/
	BR_BedString fNegativePattern;							/*%%F-%%#*/
	BR_IntegerFormatOptions fOptions;
} BR_SIntegerFormat, FAR* BR_SIntegerFormatPtr;


typedef unsigned long BR_CurrencyFormatOptions;

#define BR_CurrencyFmt_kUseDefault				(0x00000001L)
#define BR_CurrencyFmt_kUseFieldWidthFiller		(0x00000002L)
#define BR_CurrencyFmt_kForceDigitBeforeDecimal	(0x00000004L)
#define BR_CurrencyFmt_kUseAccountingZero		(0x00000008L)
#define BR_CurrencyFmt_kRightJustify				(0x00000010L)
#define BR_CurrencyFmt_kTruncateNumber			(0x00000020L)
#define BR_CurrencyFmt_kUseSymbol			(0x00000040L)
#define BR_CurrencyFmt_kIncludeDecimalDigits		(0x00000080L)

typedef struct BR_SCurrencyFormat
{
	BR_BedString fCurrencySymbol;						/*only here for reference*/
	BR_BedString fDecimalSeparator;
	BR_BedString fThousandsSeparator;
	short fThousandsSeparatorPosition;
	short fMinimumDecimalDigits;
	short fMaximumDecimalDigits;
	BR_BedString fOverflowString;
	BR_BedString fFieldWidthFiller;
	BR_BedString fAccountingZeroString;					/* -0- */
	BR_BedString fPositivePatternWithCurrencySymbol;		/*$%%F%%#*/
	BR_BedString fNegativePatternWithCurrencySymbol;			/*$%%F(%%#)*/
	BR_BedString fPositivePatternNoCurrencySymbol;		/*%%F%%# dollars*/
	BR_BedString fNegativePatternNoCurrencySymbol;			/*%%F-%%# dollars*/
	BR_CurrencyFormatOptions fOptions;
} BR_SCurrencyFormat, FAR* BR_SCurrencyFormatPtr;


typedef unsigned long BR_TimeFormatOptions;

#define BR_TimeFmt_kUseDefault			(0x00000001L)
#define BR_TimeFmt_kUseFieldWidthFiller	(0x00000002L)
#define BR_TimeFmt_kLeadingZeroOnHour	(0x00000004L)
#define BR_TimeFmt_kLeadingZeroOnMinute	(0x00000008L)
#define BR_TimeFmt_kLeadingZeroOnSecond	(0x00000010L)
#define BR_TimeFmt_kLeadingZeroOnHundredths	(0x00000020L)
#define BR_TimeFmt_kUse12HourTimeFormat		(0x00000040L)

typedef struct BR_STimeFormat
{
	BR_BedString fOverflowString;
	BR_BedString fFieldWidthFiller;
	BR_BedString fTimePattern;						/*%%H:%%M:%%S.%%1 %%2*/
	BR_TimeFormatOptions fOptions;
} BR_STimeFormat, FAR* BR_STimeFormatPtr;


typedef unsigned long BR_DateFormatOptions;

#define BR_DateFmt_kUseDefault			(0x00000001L)
#define BR_DateFmt_kUseFieldWidthFiller	(0x00000002L)
#define BR_DateFmt_kLeadingZeroOnDay 	(0x00000004L)
#define BR_DateFmt_kLeadingZeroOnMonth	(0x00000008L)
#define BR_DateFmt_kLeadingZeroOnWeek	(0x00000010L)
#define BR_DateFmt_kLeadingZeroOnYear	(0x00000020L)
#define BR_DateFmt_kIncludeCentury		(0x00000040L)
#define BR_DateFmt_kUseDayNameAbbr			(0x00000080L)
#define BR_DateFmt_kUseMonthNameAbbr			(0x00000100L)


typedef struct BR_SDateFormat
{
	BR_BedString fOverflowString;
	BR_BedString fFieldWidthFiller;
	BR_BedString fDatePattern;						/*%%D#/%%M#/%%Y# or %%DN %%MN %%D#%%th, %%Y#*/
	BR_DateFormatOptions fOptions;
} BR_SDateFormat, FAR* BR_SDateFormatPtr;



typedef unsigned long BR_CharacterAttributes;

#define BR_CharAttr_kShortDate 			(0x00000001L)  /* 1	   */
#define BR_CharAttr_kLongDate				(0x00000002L)  /* 2	   */
#define BR_CharAttr_kTime					(0x00000004L)  /* 4	   */
#define BR_CharAttr_kCurrency				(0x00000008L)  /* 8	   */
#define BR_CharAttr_kNumbers				(0x00000010L)  /* 16	   */
#define BR_CharAttr_kText					(0x00000020L)  /* 32	   */
#define BR_CharAttr_kPositiveInteger				(0x00000040L)  /* 64	   */
#define BR_CharAttr_kNegativeInteger				(0x00000080L)  /* 128	   */
#define BR_CharAttr_kPositiveFloat				(0x00000100L)  /* 256	   */
#define BR_CharAttr_kNegativeFloat				(0x00000200L)  /* 512	   */
#define BR_CharAttr_kPunctuation					(0x00000400L)  /* 1024	   */
#define BR_CharAttr_kDigit					(0x00000800L)  /* 2048	   */
#define BR_CharAttr_kOpeningPair			(0x00001000L)  /* 4096	   */
#define BR_CharAttr_kClosingPair			(0x00002000L)  /* 8192	   */
#define BR_CharAttr_kSpecificAlphabetic			(0x00004000L)  /* 16384	   */
#define BR_CharAttr_kGenericAlphabetic			(0x00008000L)  /* 32768	   */
#define BR_CharAttr_kHexadecimalDigit				(0x00010000L)  /* 65536	   */
#define BR_CharAttr_kScientificDigit			(0x00020000L)  /* 131072    */
#define BR_CharAttr_kRomanDigit			(0x00040000L)  /* 262144    */
#define BR_CharAttr_kLeadingByte				(0x10000000L)  /* 268435456 */


typedef enum BR_SortingConditions
{
	BR_SortConditions_kFull = 0,
	BR_SortConditions_kNoAlpha = 1,
	BR_SortConditions_kNoDiacritical = 2,
	BR_SortConditions_kNoCase = 4,
	BR_SortConditions_kNoSpecial = 8
} BR_SortingConditions;

enum BR_SortingWeight
{
	BR_SortWeight_kAlphabetic,
	BR_SortWeight_kDiacritical,
	BR_SortWeight_kCase,
	BR_SortWeight_kSpecial,
	BR_SortWeight_kInvalid
};

#define BR_SortValue_kUpperCase 7
#define BR_SortValue_kLowerCase 3

#define BR_INTL_LEADBYTETABLESIZE	12

typedef unsigned short BR_Country;
typedef unsigned short BR_Language;
typedef unsigned short BR_CodePage;
typedef short BR_TimeDelta;
typedef BR_Float BR_SpericalCoordinates;


enum
{
	BR_MachineType_kIBM,
	BR_MachineType_kMacintosh
};


typedef unsigned char BR_MachineType;

enum
{
	BR_ByteOrdering_kIntel,
	BR_ByteOrdering_kMotorola
};


typedef unsigned char BR_ByteOrdering;

typedef enum BR_Environment
{
	BR_Environment_kDOS,
	BR_Environment_kWindows,
	BR_Environment_kMacintosh,
	BR_Environment_kOS2,
	BR_Environment_kNT
} BR_Environment;

typedef struct BR_SLocalityInformation
{
	BR_MachineType fMachineType;
	BR_ByteOrdering fByteOrdering;
	BR_Country fCountryId;
	BR_Language fLanguageId;
	BR_CodePage fActiveCodePage;
	BR_Environment fActiveOSEnv;
	BR_CharacterSetId fActiveCharacterSetpingId;
} BR_SLocalityInformation, FAR* BR_SLocalityInformationPtr;


typedef struct BR_SIntlInformation
{
	BR_Country fCountry;
	BR_CodePage fCodePage;
	BR_Language fLanguage;
	BR_Country fOEMCountry;
	BR_CodePage fOEMCodePage;
	BR_Language fOEMLanguage;
	BR_Boolean fMetricSystem;
	BR_CharacterSetTypes fCharacterSetType;		/* SBCS is default */
	BR_TextDirections fCharacterDirection;
	BR_TimeDelta fTimeZone;						/*minutes difference from GMT*/
	BR_SpericalCoordinates fLongitude;
	BR_SpericalCoordinates fLatitude;
	BR_BedString fListSeparator;
	BR_FormattingWidth fDefaultCurrencyFieldWidth;
	BR_FormattingWidth fDefaultNumberFieldWidth;
	BR_Boolean fDefaultTimeFormat;				/*True = 24 fHour, False = 12 fHour*/
	BR_SDateTimeNamesPtr fDateTimeNames;
	BR_SFloatFormatPtr fFloatNumberFormat;
	BR_SIntegerFormatPtr fIntegerNumberFormat;
	BR_SCurrencyFormatPtr fCurrencyFormat;
	BR_STimeFormatPtr fHour12TimeFormat;
	BR_STimeFormatPtr fHour24TimeFormat;
	BR_STimeFormatPtr fFileSystemTimeFormat;
	BR_SDateFormatPtr fShortDateFormat;
	BR_SDateFormatPtr fLongDateFormat;
	unsigned char fCollate1[256];							/*each character with regard to case*/
	unsigned short fCollate2[256];				/*Case is secondary sort parameter*/
	unsigned char fUpperCasemap[256];
	unsigned char fLowerCasemap[256];
	BR_CharacterAttributes fCharacterType[256];		/* Defines character types BEDCT_?  */
#ifdef	BR_BUILD_WIN
	HANDLE fSortTables[BR_SortWeight_kInvalid];
#endif

#ifdef BR_BUILD_MAC
	Handle fSortTables[BR_SortWeight_kInvalid];
#endif

	BR_StringCharacter fSpace;
	BR_StringCharacter fTab;
	BR_SLocalityInformationPtr fLocality;
} BR_SIntlInformation, FAR* BR_SIntlInformationPtr;

#ifdef	BR_BUILD_WIN
extern HANDLE BR_gIntlModule;
#endif

/* International Procedure Prototypes */

BR_EXPORTENTRY(void) BR_IntlTerminate (void);
BR_EXPORTENTRY(BR_Boolean) BR_InitIntl (void);
BR_EXPORTENTRY(BR_Boolean) BR_IsMetric (void);
BR_EXPORTENTRY(BR_Boolean) BR_IsDBCS (void);
BR_EXPORTENTRY(BR_SIntlInformationPtr) BR_GetIntlInfo (void);
BR_EXPORTENTRY(BR_Boolean) BR_SetIntlInfo (BR_SIntlInformationPtr pInfo);


BR_EXPORTENTRY(BR_Boolean) BR_IsNumeric (BR_StringCharacter c, BR_CharacterAttributes myType);
BR_EXPORTENTRY(BR_Boolean) BR_IsAlpha (BR_StringCharacter c, BR_Boolean typeSpecific);
BR_EXPORTENTRY(BR_Boolean) BR_IsLower (BR_StringCharacter c);
BR_EXPORTENTRY(BR_Boolean) BR_IsUpper (BR_StringCharacter c);
BR_EXPORTENTRY(BR_StringCharacter) BR_ToLower (BR_StringCharacter c);
BR_EXPORTENTRY(BR_StringCharacter) BR_ToUpper (BR_StringCharacter c);
BR_EXPORTENTRY(BR_Boolean) BR_IsWhiteSpaceCharacter (BR_StringCharacter c);
#define BR_IsDigit(_c) BR_IsNumeric(_c,BR_CharAttr_kDigit)
#define BR_IsPunctuation(_c) BR_IsNumeric(_c,BR_CharAttr_kPunctuation)
#define BR_IsLeadingByte(_c) BR_IsNumeric(_c,BR_CharAttr_kLeadingByte)
#define BR_IsAlphaNumeric(_c) BR_IsNumeric(_c,BR_CharAttr_kDigit|BR_CharAttr_kGenericAlphabetic)

/*
   Note the following to functions allow us to traverse a string no matter
   if the string is SBCS, DBCS, MBCS, or JIS.
*/

BR_EXPORTENTRY(BR_Boolean) BR_SetStringCharacterTraversal (BR_CodePage codepage, BR_Country fCountry, BR_Language fLanguage);
BR_EXPORTENTRY(BR_StringPtr) BR_NextStringCharacter (BR_StringPtr pPos);
BR_EXPORTENTRY(BR_StringPtr) BR_PrevStringCharacter (BR_StringPtr pStart, BR_StringPtr pPos);


BR_EXPORTENTRY(BR_BedString) BR_BedStringFormatFloat (
   BR_Float		 			f,
   BR_SFloatFormatPtr    	ff,
   BR_FloatFormatOptions	fOptions,
   short				    strMax,
   BR_BedString					s,
   BR_FormattingWidth	  	fieldSize,
   short					fMinimumDecimalDigits,
   short					fMaximumDecimalDigits);

BR_EXPORTENTRY(BR_StringPtr) BR_FormatFloat (
	BR_Float f,
	BR_SFloatFormatPtr ff,
	BR_FloatFormatOptions fOptions,
	short FAR* strMax,
	BR_StringPtr s,
	BR_FormattingWidth fieldSize,
	short fMinimumDecimalDigits,
	short fMaximumDecimalDigits);

BR_EXPORTENTRY(BR_BedString) BR_BedStringFormatInteger (
   long 	     l,
   BR_SIntegerFormatPtr    ifmt,
   BR_IntegerFormatOptions fOptions,
   short      strMax,
   BR_BedString	  s,
   BR_FormattingWidth	     fieldSize);

BR_EXPORTENTRY(BR_BedString) BR_FormatInteger (
   long 	     l,
   BR_SIntegerFormatPtr    ifmt,
   BR_IntegerFormatOptions fOptions,
   short FAR *      strMax,
   BR_StringPtr	 s,
   BR_FormattingWidth	     fieldSize);

BR_EXPORTENTRY(BR_BedString) BR_BedStringFormatULong (
   unsigned long	      l,
   BR_SIntegerFormatPtr    ifmt,
   BR_IntegerFormatOptions fOptions,
   short      strMax,
   BR_BedString	  s,
   BR_FormattingWidth	     fieldSize);

BR_EXPORTENTRY(BR_BedString) BR_FormatULong (
   unsigned long	      l,
   BR_SIntegerFormatPtr    ifmt,
   BR_IntegerFormatOptions fOptions,
   short FAR *      strMax,
   BR_StringPtr	 s,
   BR_FormattingWidth	     fieldSize);


BR_EXPORTENTRY(BR_BedString) BR_BedStringFormatCurrency (
   BR_Float	      c,
   BR_SCurrencyFormatPtr    cfmt,
   BR_CurrencyFormatOptions fOptions,
   short       strMax,
   BR_BedString	   s,
   BR_FormattingWidth	      fieldSize);

BR_EXPORTENTRY(BR_BedString) BR_FormatCurrency (
   BR_Float	c,
   BR_SCurrencyFormatPtr	cfmt,
   BR_CurrencyFormatOptions	fOptions,
   short FAR *	strMax,
   BR_StringPtr	s,
   BR_FormattingWidth	fieldSize);


BR_EXPORTENTRY(BR_BedString) BR_BedStringFormatDate (
   BR_SDateTimePtr	  pdt,
   BR_SDateFormatPtr	  dfmt,
   BR_DateFormatOptions fOptions,
   short	strMax,
   BR_BedString	   s,
   BR_FormattingWidth	      fieldSize);

BR_EXPORTENTRY(BR_BedString) BR_FormatDate (
   BR_SDateTimePtr	  pdt,
   BR_SDateFormatPtr	  dfmt,
   BR_DateFormatOptions fOptions,
   short FAR *	strMax,
   BR_StringPtr	  s,
   BR_FormattingWidth	      fieldSize);


BR_EXPORTENTRY(BR_BedString) BR_BedStringFormatTime (
   BR_SDateTimePtr	  pdt,
   BR_STimeFormatPtr	  tfmt,
   BR_TimeFormatOptions fOptions,
   short       strMax,
   BR_BedString	   s,
   BR_FormattingWidth	      fieldSize);

BR_EXPORTENTRY(BR_BedString) BR_FormatTime (
   BR_SDateTimePtr	  pdt,
   BR_STimeFormatPtr	  tfmt,
   BR_TimeFormatOptions fOptions,
   short FAR *	strMax,
   BR_StringPtr	  s,
   BR_FormattingWidth	      fieldSize);


BR_EXPORTENTRY(BR_StringCompareResult) BR_IntlCompString (BR_BedString s1, BR_BedString s2);  /*uses fCollate2*/

BR_EXPORTENTRY(BR_StringCompareResult) BR_IntlEqualString (BR_BedString s1, BR_BedString s2); /*uses fCollate2*/

BR_EXPORTENTRY(BR_StringCompareResult) BR_IntlOrderString (BR_BedString s1, BR_BedString s2); /*uses fCollate1*/
BR_EXPORTENTRY(BR_StringCompareResult) BR_CompareStrings (BR_StringPtr p1, BR_StringPtr p2, short l1, short l2, short sortType);

BR_EXPORTENTRY(BS_StringLength) BR_CharacterSetTranslate(
	BR_CharacterSetId srcID,
	BR_CharacterSetId destID,
	void FAR * src,
	BS_StringLength cntCharacters,
	void FAR * dest, 
	unsigned short maxlen);


#ifdef BR_BEDINTL_INIT_ONLY
#ifdef BR_BEDPROCESSIDSCHEME
BR_EXPORTENTRY(short) BR_IntlGetProcessIdCount (void);
BR_EXPORTENTRY(void) BR_IntlSetProcessIdCount (short i);

#ifdef BUILD_PM
BR_EXPORTENTRY(PID) BR_IntlGetProcessId (short i);
BR_EXPORTENTRY(void) BR_IntlSetProcessId (PID p, short i);
#endif

#ifdef BR_BUILD_WIN
BR_EXPORTENTRY(HANDLE) BR_IntlGetProcessId (short i);
BR_EXPORTENTRY(void) BR_IntlSetProcessId (HANDLE p, short i);
#endif

BR_EXPORTENTRY(BR_SIntlInformationPtr) BR_IntlGetIntlInfo (short i);
BR_EXPORTENTRY(void) BR_IntlSetIntlInfo (BR_SIntlInformationPtr ii, short i);
BR_EXPORTENTRY(BR_SIntlInformationPtr) BR_IntlGetDefaultIntlInfo (short i);
BR_EXPORTENTRY(void) BR_IntlSetDefaultIntlInfo (BR_SIntlInformationPtr ii, short i);

#else
BR_EXPORTENTRY(BR_Boolean) BR_IntlGetInstalledState (void);
BR_EXPORTENTRY(void) BR_IntlSetInstalledState (BR_Boolean b);
BR_EXPORTENTRY(BR_SIntlInformationPtr) BR_IntlGetIntlInfo (void);
BR_EXPORTENTRY(void) BR_IntlSetIntlInfo (BR_SIntlInformationPtr ii);
BR_EXPORTENTRY(BR_SIntlInformationPtr) BR_IntlGetDefaultIntlInfo (void);
BR_EXPORTENTRY(void) BR_IntlSetDefaultIntlInfo (BR_SIntlInformationPtr ii);
#endif
#endif
 
#ifdef __cplusplus
  }
#endif

#endif

