#ifndef BRWIDSTR_H
#define BRWIDSTR_H
//========================================================================================
//
//     File:		BRWidStr.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	4/2/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRCHARAC_H
#include "BRCharac.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

#ifndef BRCHARIT_H
#include "BRCharIt.h"
#endif

//========================================================================================
//	CLASS BR_CDynamicWideCharString
//========================================================================================

class BR_CDynamicWideCharString : public BR_TDynamicString<BR_WideChar>
{
	friend class BR_TStringWriter<BR_WideChar, BR_CDynamicWideCharString>;
	
public:

	~BR_CDynamicWideCharString();
	BR_CDynamicWideCharString();
	BR_CDynamicWideCharString(const BR_TString<BR_WideChar> &string);
	BR_CDynamicWideCharString(const BR_WideChar* items, BR_CharacterCount numberItems);
	BR_CDynamicWideCharString(const BR_WideChar* items);
	
	BR_CDynamicWideCharString(const BR_TString<BR_Char> &string);
	BR_CDynamicWideCharString(const BR_Char *items, BR_CharacterCount numberItems);
	BR_CDynamicWideCharString(const BR_Char *items);

	BR_TString<BR_WideChar>& operator=(const BR_TString<BR_WideChar>& string);
	BR_TString<BR_WideChar>& operator=(const BR_WideChar* string);

	BR_TString<BR_WideChar>& operator=(const BR_TString<BR_Char>& string);
	BR_TString<BR_WideChar>& operator=(const BR_Char* string);
};

//----------------------------------------------------------------------------------------
//	BR_CDynamicWideCharString::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_WideChar>& 
BR_CDynamicWideCharString::operator=(const BR_TString<BR_WideChar>& string)
{
	if (&string != this)
		ReplaceAll(string);
	return *this;
}

//----------------------------------------------------------------------------------------
//	BR_CDynamicWideCharString::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_WideChar>& 
BR_CDynamicWideCharString::operator=(const BR_WideChar* string)
{
	ReplaceAll(string, BR_StringLength(string));
	return *this;
}

//========================================================================================
//	CLASS BR_CDynamicWideCharStringWriter
//========================================================================================

class BR_CDynamicWideCharStringWriter : public BR_TStringWriter<BR_WideChar, BR_CDynamicWideCharString>
{
public:
	BR_CDynamicWideCharStringWriter(BR_CDynamicWideCharString &string, BR_TextWriterMode mode=BR_kTextAppend) :  
		BR_TStringWriter<BR_WideChar, BR_CDynamicWideCharString>(string, mode) {}
};

//========================================================================================
//	CLASS BR_CWideCharString255
//========================================================================================

const unsigned short BR_kWideCharString255Capacity = 255;

class BR_CWideCharString255 : public BR_TBoundedString<BR_WideChar, 255>
{
	friend class BR_TStringWriter<BR_WideChar, BR_CWideCharString255>;

public:
	~BR_CWideCharString255();
	BR_CWideCharString255();
	BR_CWideCharString255(const BR_TString<BR_WideChar> &string);
	BR_CWideCharString255(const BR_WideChar* items, BR_CharacterCount numberItems);
	BR_CWideCharString255(const BR_WideChar* items);
	
	
	BR_CWideCharString255(const BR_TString<BR_Char> &string);
	BR_CWideCharString255(const BR_Char *items, BR_CharacterCount numberItems);
	BR_CWideCharString255(const BR_Char *items);

	BR_TString<BR_WideChar>& operator=(const BR_TString<BR_WideChar>& string);
	BR_TString<BR_WideChar>& operator=(const BR_WideChar* string);

	BR_TString<BR_WideChar>& operator=(const BR_TString<BR_Char>& string);
	BR_TString<BR_WideChar>& operator=(const BR_Char* string);
};

//----------------------------------------------------------------------------------------
//	BR_CWideCharString255::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_WideChar>& 
BR_CWideCharString255::operator=(const BR_TString<BR_WideChar>& string)
{
	if (&string != this)
		ReplaceAll(string);
	return *this;
}

//----------------------------------------------------------------------------------------
//	BR_CWideCharString255::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_WideChar>& 
BR_CWideCharString255::operator=(const BR_WideChar* string)
{
	ReplaceAll(string, BR_StringLength(string));
	return *this;
}

//========================================================================================
//	CLASS BR_CWideCharString255Writer
//========================================================================================

class BR_CWideCharString255Writer : public BR_TStringWriter<BR_WideChar, 
															BR_CWideCharString255>
{
public:
	BR_CWideCharString255Writer(BR_CWideCharString255 &string, BR_TextWriterMode mode=BR_kTextAppend) :  
		BR_TStringWriter<BR_WideChar, BR_CWideCharString255>(string, mode) {}
};

//========================================================================================
//	CLASS BR_CWideCharString32
//========================================================================================

const unsigned short BR_kWideCharString32Capacity = 32;

class BR_CWideCharString32 : public BR_TBoundedString<BR_WideChar, 32>
{
	friend class BR_TStringWriter<BR_WideChar, BR_CWideCharString32>;

public:
	~BR_CWideCharString32();
	BR_CWideCharString32();
	BR_CWideCharString32(const BR_TString<BR_WideChar> &string);
	BR_CWideCharString32(const BR_WideChar* items, BR_CharacterCount numberItems);
	BR_CWideCharString32(const BR_WideChar* items);
	
	
	BR_CWideCharString32(const BR_TString<BR_Char> &string);
	BR_CWideCharString32(const BR_Char *items, BR_CharacterCount numberItems);
	BR_CWideCharString32(const BR_Char *items);

	BR_TString<BR_WideChar>& operator=(const BR_TString<BR_WideChar>& string);
	BR_TString<BR_WideChar>& operator=(const BR_WideChar* string);

	BR_TString<BR_WideChar>& operator=(const BR_TString<BR_Char>& string);
	BR_TString<BR_WideChar>& operator=(const BR_Char* string);
};

//----------------------------------------------------------------------------------------
//	BR_CWideCharString32::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_WideChar>& 
BR_CWideCharString32::operator=(const BR_TString<BR_WideChar>& string)
{
	if (&string != this)
		ReplaceAll(string);
	return *this;
}

//----------------------------------------------------------------------------------------
//	BR_CWideCharString32::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_WideChar>& 
BR_CWideCharString32::operator=(const BR_WideChar* string)
{
	ReplaceAll(string, BR_StringLength(string));
	return *this;
}

//========================================================================================
//	CLASS BR_CWideCharString32Writer
//========================================================================================

class BR_CWideCharString32Writer : public BR_TStringWriter<BR_WideChar, 
															BR_CWideCharString32>
{
public:
	BR_CWideCharString32Writer(BR_CWideCharString32 &string, BR_TextWriterMode mode=BR_kTextAppend) :  
		BR_TStringWriter<BR_WideChar, BR_CWideCharString32>(string, mode) {}
};

//========================================================================================
//	CLASS BR_CUniversalWideCharStringReader
//========================================================================================

class BR_CUniversalWideCharStringReader : public BR_TUniversalStringReader<BR_WideChar>
{
public:
	BR_CUniversalWideCharStringReader(const BR_TString<BR_WideChar> &string) :  
		BR_TUniversalStringReader<BR_WideChar>(string) {}
};

#endif
