//========================================================================================
//
//      File:		BRLocale.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================


#ifndef	BRLOCALE_H
#define	BRLOCALE_H
#endif

#ifndef	BRWRISYS_H
#include "BRWRISYS.H"
#endif

//========================================================================================
//	CLASS BR_CLocale
//========================================================================================
//========================================================================================

//										BR_CLocale	Design Objectives

//	Responsibilities	:
		//	THis class is the only class with dependence on specific OS
		//	BR_CLocale houses all the international primitive data items.
		//	BR_CLocale dictates to the writing system built upon it the following:
		//		Formats
		//		Script properties
		//		Sort Orders
		//		Breaking / text boundaries behavior
		//		Casing
		//		Mapping / character set translation tables and related behaviors
		//		Character Attributes
		//		

//	Tasks	It can conduct :
		//	Retrieve the primitive to fill its data members from the system
		//	Access to its data members for 2 reasons
		//		first : 
		//		second:	so a new non-existent locale can be created

//	Collaborators			:
		//	This is a pure server class, it affects the behaviour of all the international system of classes

//	Where Constructed	:
		//	When the framework or application request the default or any new writing system 
		//	the default or a new locale class is sought by the writing system,
		//	If the request is the first one for a locale with this ID or characteristics
		//	it is constructed by the writing system 
		//	else the existing one is used

//	Data Members		:
		//	
		//	CountryId;	//	country code as set by AT&T and adopted by ISO
		//	LanguageId;
		//	ScriptId;
		//	MetricSystem;	//	set when the metric system is the system of the locale
		//	TimeZone;				//	minutes difference from GMT
		//	SphericalCoordinates : Longitude;				//	
		//	SphericalCoordinates : Latitude;				//	earth location
		//	ExternalCharacterSet;		//
		//	KeyboardLayoutID;		//	
		
//========================================================================================


class BR_CLocale
{
public:

	//	instantiating a BR_CLocale object should return an int which represents the locale ID
	BR_LocaleID BR_CLocale();
	BR_LocaleID BR_CLocale(BR_LocaleID = UNICODE);

	//	dangerous, could be used before a default locale is created. Check for that condition
	BR_LocaleID BR_CLocale(BR_CLocale* aLocale = GetCurrentLocale());

	~BR_CLocale();

	BR_CLocale* GetCurrentLocale() const;
	BR_Boolean SetCurrentLocale(BR_CLocale* alocale);

	BR_CLocale* GetDefaultLocale() const;
	BR_Boolean SetDefaultLocale(BR_CLocale* alocale);

	//	void BR_Terminate ();

	BR_Country GetCountryId() const;
	BR_Boolean SetCountryId(BR_Country countryID);

	BR_Language GetLanguageId() const;
	BR_Boolean SetLanguageId(BR_Language languageID);

	BR_Script GetScriptId() const;
	BR_Boolean SetScriptId(BR_Script scriptID);

	BR_TimeDelta GetTimeZone() const;
	BR_Boolean SetTimeZone(BR_TimeDelta timeZone);

	BR_SphericalCoordinates GetLongitude() const;
	BR_Boolean SetLongitude(BR_SphericalCoordinates longitude);

	BR_SphericalCoordinates GetLatitude() const;
	BR_Boolean SetLatitude(BR_SphericalCoordinates latitude);

	BR_CharacterSet GetExternalCharacterSet() const;
	BR_Boolean SetExternalCharacterSet(BR_CharacterSet externalCharacterSetID);

	BR_Boolean BR_IsMetric() const;

	BR_Boolean BR_IsDBCS() const;

protected:
	BR_Boolean BR_InitLocale();					//	system specific calls should be here 

private:


	BR_CCountry::CountryID fCountryId;			//	country code as set by AT&T and adopted by ISO
	BR_CLanguage::LanguageID fLanguageId;
	BR_CScript::ScriptID fScriptId;
	BR_CCharacterSet::CharacterSetID fExternalCharacterSet;//
	BR_CKeyboardTable::KeyboardID fKeyboardLayoutID;//	

	BR_Boolean fMetricSystem;					//	set when the metric system is the system of the locale
	BR_TimeDelta fTimeZone;						//	minutes difference from GMT
	BR_SphericalCoordinates fLongitude;			//	
	BR_SphericalCoordinates fLatitude;			//	earth location
};




class BR_CCountry
{
public :
	enum CountryID
	{	
		Us			=	1, 
		Japan	=	100, 
		Egypt	=	200,
		Israel	=	250,
		Russia	=	300, 
		India	=	400

	};
};


class BR_CLanguage
{
public :
	enum LanguageID
	{
		Unknown			=	0,
		English	 		=	1 ,		
		Frensh				,				
		German		 ,
		Italian		 ,
		Dutch		 ,
		Sweedish		 ,
		Finnish		 ,
		Spanish		 ,
		Portugaise		 ,
		Katalan		 ,
		Gaelic		 ,
		Flemish		 ,
		SwissGerman		 ,
		SwissFrensh		 ,
		Turkish		 ,
		Yidish		,
	
		Japanese				= 100 ,		
		Mandarin				= 101 ,
		Cantonese				= 102 ,
		Korean					= 103 , 
	
		Arabic					= 200 ,	
		Farsi	,
		Urdu	,
		Baluchi	,
		Kashmiri	,
		Kazakh	,
		Sindhi	,
		Pashto	,
		Lahnda	,
		Kurdish	,
		Dargwa	,
		Uighur	,
		Turkic	,
		Berber	,
		OldHusa	,
		OldMalay	,
		Adighe	,
		Ingush	,
		Kirghiz	,
		Maldivan	,

		Hebrew					= 250 ,
	
		Russian				= 300 ,
		
		Slav		 ,
		Croatian		 ,
		Serb		 ,
		Czeck		 ,
		Macedonean		 ,
		Greeck		 ,
	
		IndicDevanagari		= 400 ,
		IndicBengali			= 401 ,
		IndicGurmkhi			= 402 ,
		IndicGujarati			= 403 ,
		IndicOriya				= 404 ,
		IndicTamil				= 405 ,
		IndicTelugu			= 406 ,
		IndicKannada			= 407 ,
		IndicMalayalam			= 408 ,
		IndicThai				= 450 ,
		IndicLao				= 460 ,

	
	};
};

class BR_CScript
{
public :
	enum ScriptID
	{
		Latin	=	0, 
		Roman	=	1,
		Ascii	=	2,
		Ansi	=	3,
		European	=	4,
		Phonetic	=	5,
		Math	=	6,
		
		Kanji	=	100,
		Hiragana	=	101,
		Katakana	=	102,
		Hanzi	=	110,
		Hanza	=	110,
		Bopomofo	=	111,
	
		Hangul	=	120,
		ChaUm	=	121,
		Jamo	=	121,
		
		Arabic					=	200,
		NorthAfricanArabic	=	201,
		ExtendedArabic			=	202,
	
		Cyrrilic				=	300,
		Greek					=	301,
		Slav					=	302,
		
		IndicDevanagari		= 	400 ,
		IndicBengali			= 	401 ,
		IndicGurmkhi			= 	402 ,
		IndicGujarati			= 	403 ,
		IndicOriya				= 	404 ,
		IndicTamil				= 	405 ,
		IndicTelugu			=	406 ,
		IndicKannada			= 	407 ,
		IndicMalayalam			= 	408 ,
		IndicThai				= 	450 ,
		IndicLao				= 	460 ,


	};
};

class BR_CCharacterSet
{
public :
	enum CharacterSetID
	{
		Unicode	=	0,
		
		//	Us Code Sets
		CharacterSetMacM4	=	1,
		CharacterSet437		=	5,
		CharacterSetWin31		=	6,
		CharacterSetWin30		=	7,
		
		
		//	European (Roman & Latin Based) Code Sets
		CharacterSet850	=	10,
		CharacterSet852	=	11,
		CharacterSet855	=	12,
		CharacterSet857	=	13,
		CharacterSet860	=	14,
		CharacterSet861	=	15,
		CharacterSet863	=	16,
		CharacterSet864	=	17,
		CharacterSet865	=	18,
		CharacterSet869	=	19,

		CharacterSet1004	=	50,
		CharacterSetGcgid	=	99,

		//	Asian / Han Character Set Standards		
		CharacterSetJis		=	100,

		CharacterSetBig5		=	110,
		CharacterSetFujitsu	=	111,
		CharacterSetXerox		=	112,

		CharacterSetAnsi		=	120,
		CharacterSetGb		=	121,
		CharacterSetCccii		=	122,

		CharacterSetCns	=	150,
		CharacterSetKsc	=	180,
		
		//	Arabic  Character Set Standards		

		ArabicAnsi		=	200,
		ArabicWin31	=	201,
		ArabicMac		=	202,
		
		Arabic123		,	//	Lotus 123
		Arabic708		,	//	Ecma
		Arabic709		,
		Arabic710		,
		Arabic711		,
		Arabic720		,
		Arabic786		,
		
		Arabic864		,	
		
		ArabicA449		,	//	Asmo 
		ArabicA708		,
		
		ArabicBil		,
		ArabicI864		,	
		ArabicLot		,	//	Lotus Other
		ArabicMa2		,
		ArabicNae		,
		ArabicNaf		,	//	Annafitha
		ArabicTarb		,
		ArabicTasmo	,
		ArabicV4		,
		ArabicWarb		,
		ArabicWord		,	//	Arabword
		ArabicWp		,	//	Word Perfect


	
		Cyrrilic	=	300,
		Greek	=	301,
		Slav	=	302,
		
		IndiaIscii	=	400,


	};
};

