//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCStoreM.h
//
//  This file contains the declaration of the managed storage
//  management class utility.

#ifndef BCSTOREM_H
#define BCSTOREM_H 1

#include "BCPool.h"

// Class utility providing a managed memory allocation/deallocation protocol

class BC_CManaged {
public:

  static BC_CPool& fPool;

  static void* Allocate(size_t s) 
    {return fPool.Allocate(s);}
  static void Deallocate(void* p, size_t s) 
    {fPool.Deallocate(p, s);}

private:

  BC_CManaged() 
    {}
  BC_CManaged(BC_CManaged&) 
    {}
  void operator=(BC_CManaged&) 
    {}
  void operator==(BC_CManaged&) 
    {}
  void operator!=(BC_CManaged&) 
    {}

};

#endif
