//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCStoreC.h
//
//  This file contains the declaration of the controlled storage
//  management class utility.

#ifndef BCSTOREC_H
#define BCSTOREC_H 1

#include "BCPool.h"
#include "BCSynch.h"

// Class utility providing a controlled memory allocation/deallocation protocol

class BC_CControlled {
public:

  static BC_CPool& fPool;

  static void* Allocate(size_t s) 
    {BC_CLock Lock(fPoolLock); 
     return fPool.Allocate(s);}
  static void Deallocate(void* p, size_t s) 
    {BC_CLock Lock(fPoolLock); 
     fPool.Deallocate(p, s);}

private:

  static BC_CSemaphore fPoolLock;

  BC_CControlled() 
    {}
  BC_CControlled(BC_CControlled&) 
    {}
  void operator=(BC_CControlled&) 
    {}
  void operator==(BC_CControlled&) 
    {}
  void operator!=(BC_CControlled&) 
    {}

};

#endif
