//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCQueU.h
//
//  This file contains the declaration of the unbounded queue.

#ifndef BCQUEU_H
#define BCQUEU_H 1

#include "BCUnboun.h"
#include "BCQue.h"

// Unbounded queue

template<class Queue_Item, class Storage_Manager>
class BC_TUnboundedQueue : public BC_TQueue<Queue_Item> {
public:

  BC_TUnboundedQueue();
  BC_TUnboundedQueue(const BC_TUnboundedQueue<Queue_Item, Storage_Manager>&);
  virtual ~BC_TUnboundedQueue();

  virtual BC_TQueue<Queue_Item>& operator=(const BC_TQueue<Queue_Item>&);
  virtual BC_TQueue<Queue_Item>& operator=(const BC_TUnboundedQueue<Queue_Item, Storage_Manager>&);
  virtual BC_Boolean operator==(const BC_TQueue<Queue_Item>&) const;
  virtual BC_Boolean operator==(const BC_TUnboundedQueue<Queue_Item, Storage_Manager>&) const;
  BC_Boolean operator!=(const BC_TUnboundedQueue<Queue_Item, Storage_Manager>&) const;

  virtual void Clear();
  virtual void Append(const Queue_Item&);
  virtual void Pop();
  virtual void Remove(BC_Index at);

  virtual BC_Index Length() const;
  virtual BC_Boolean IsEmpty() const;
  virtual const Queue_Item& Front() const;
  virtual BC_Extended_Index Location(const Queue_Item&) const;

  static void* operator new(size_t);
  static void operator delete(void*, size_t);

protected:

  BC_TUnbounded<Queue_Item, Storage_Manager> fRep;
  
  virtual void Purge();
  virtual void Add(const Queue_Item&);
  virtual BC_Index Cardinality() const;
  virtual const Queue_Item& Item(BC_Index) const;
  
};

#endif
