//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCQueB.h
//
//  This file contains the declaration of the bounded queue.

#ifndef BCQUEB_H
#define BCQUEB_H 1

#include "BCBound.h"
#include "BCQue.h"

// Bounded queue

template<class Queue_Item, BC_Index Size>
class BC_TBoundedQueue : public BC_TQueue<Queue_Item> {
public:

  BC_TBoundedQueue();
  BC_TBoundedQueue(const BC_TBoundedQueue<Queue_Item, Size>&);
  virtual ~BC_TBoundedQueue();

  virtual BC_TQueue<Queue_Item>& operator=(const BC_TQueue<Queue_Item>&);
  virtual BC_TQueue<Queue_Item>& operator=(const BC_TBoundedQueue<Queue_Item, Size>&);
  virtual BC_Boolean operator==(const BC_TQueue<Queue_Item>&) const;
  virtual BC_Boolean operator==(const BC_TBoundedQueue<Queue_Item, Size>&) const;
  BC_Boolean operator!=(const BC_TBoundedQueue<Queue_Item, Size>&) const;

  virtual void Clear();
  virtual void Append(const Queue_Item&);
  virtual void Pop();
  virtual void Remove(BC_Index at);

  virtual BC_Index Available() const;
  virtual BC_Index Length() const;
  virtual BC_Boolean IsEmpty() const;
  virtual const Queue_Item& Front() const;
  virtual BC_Extended_Index Location(const Queue_Item&) const;

protected:

  BC_TBounded<Queue_Item, Size> fRep;

  virtual void Purge();
  virtual void Add(const Queue_Item&);
  virtual BC_Index Cardinality() const;
  virtual const Queue_Item& Item(BC_Index) const;
  
  static void* operator new(size_t);
  static void operator delete(void*, size_t);

};

#endif
