//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCMapD.h
//
//  This file contains the declaration of the dynamic map.

#ifndef BCMAPD_H
#define BCMAPD_H 1

#include "BCNodes.h"
#include "BCDynami.h"
#include "BCHashTa.h"
#include "BCMap.h"

// Dynamic map

template<class Map_Item, class Map_Value, BC_Index Buckets, class Storage_Manager>
class BC_TDynamicMap : public BC_TMap<Map_Item, Map_Value> {
public:

  BC_TDynamicMap();
  BC_TDynamicMap(BC_Index (*)(const Map_Item&));
  BC_TDynamicMap(BC_Index chunkSize);
  BC_TDynamicMap(const BC_TDynamicMap<Map_Item, Map_Value, Buckets, Storage_Manager>&);
  virtual ~BC_TDynamicMap();

  virtual BC_TMap<Map_Item, Map_Value>& operator=(const BC_TMap<Map_Item, Map_Value>&);
  virtual BC_TMap<Map_Item, Map_Value>&
    operator=(const BC_TDynamicMap<Map_Item, Map_Value, Buckets, Storage_Manager>&);
  virtual BC_Boolean operator==(const BC_TMap<Map_Item, Map_Value>&) const;
  virtual BC_Boolean 
    operator==(const BC_TDynamicMap<Map_Item, Map_Value, Buckets, Storage_Manager>&) const;
  BC_Boolean 
    operator!=(const BC_TDynamicMap<Map_Item, Map_Value, Buckets, Storage_Manager>&) const;

  virtual void SetHashFunction(BC_Index (*)(const Map_Item&));
  virtual void SetChunkSize(BC_Index chunkSize);
  virtual void Clear();
  virtual void Preallocate(BC_Index new_length);
  virtual BC_Boolean Bind(const Map_Item&, const Map_Value&);
  virtual BC_Boolean Rebind(const Map_Item&, const Map_Value&);
  virtual BC_Boolean Unbind(const Map_Item&);

  virtual BC_Index ChunkSize() const;
  virtual BC_Index Extent() const;
  virtual BC_Boolean IsEmpty() const;
  virtual BC_Boolean IsBound(const Map_Item&) const;
  virtual const Map_Value* Value(const Map_Item&) const;

  static void* operator new(size_t);
  static void operator delete(void*, size_t);

protected:

  BC_TTable<Map_Item, Map_Value, Buckets, BC_TDynamic<BC_TPair<Map_Item, Map_Value>, Storage_Manager> > 
    fRep;

  virtual void Purge();
  virtual BC_Boolean Attach(const Map_Item&, const Map_Value&);
  virtual BC_Index Cardinality() const;
  virtual BC_Index NumberOfBuckets() const;
  virtual BC_Index Length(BC_Index bucket) const;
  virtual BC_Boolean Exists(const Map_Item&) const;
  virtual const Map_Item& Item(BC_Index bucket, BC_Index index) const;
  virtual const Map_Value& Value(BC_Index bucket, BC_Index index) const;

};

#endif
