//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCOColD.h
//
//  This file contains the declaration of the dynamic ordered collection.

#ifndef BCOCOLD_H
#define BCOCOLD_H 1

#include "BCDynami.h"
#include "BCOCol.h"

// Dynamic ordered collection

template<class Collection_Item, class Storage_Manager>
class BC_TDynamicOrderedCollection : public BC_TOrderedCollection<Collection_Item> {
public:

  BC_TDynamicOrderedCollection();
  BC_TDynamicOrderedCollection(BC_Index chunkSize);
  BC_TDynamicOrderedCollection
    (const BC_TDynamicOrderedCollection<Collection_Item, Storage_Manager>&);
  virtual ~BC_TDynamicOrderedCollection();

  virtual BC_TCollection<Collection_Item>& operator=(const BC_TCollection<Collection_Item>&);
  virtual BC_TCollection<Collection_Item>&
    operator=(const BC_TDynamicOrderedCollection<Collection_Item, Storage_Manager>&);
  virtual BC_Boolean operator==(const BC_TCollection<Collection_Item>&) const;
  virtual BC_Boolean
    operator==(const BC_TDynamicOrderedCollection<Collection_Item, Storage_Manager>&) const;
  BC_Boolean
    operator!=(const BC_TDynamicOrderedCollection<Collection_Item, Storage_Manager>&) const;
  virtual const Collection_Item& operator[](BC_Index) const;

  virtual void SetChunkSize(BC_Index chunkSize);
  virtual void Preallocate(BC_Index new_length);
  virtual void Clear();
  virtual void Insert(const Collection_Item&);
  virtual void Insert(const Collection_Item&, BC_Index before);
  virtual void Append(const Collection_Item&);
  virtual void Append(const Collection_Item&, BC_Index after);
  virtual void Remove(BC_Index at);
  virtual void Replace(BC_Index at, const Collection_Item&);

  virtual BC_Index ChunkSize() const;
  virtual BC_Index Length() const;
  virtual BC_Boolean IsEmpty() const;
  virtual const Collection_Item& First() const;
  virtual const Collection_Item& Last() const;
  virtual BC_Extended_Index Location(const Collection_Item&) const;

  static void* operator new(size_t);
  static void operator delete(void*, size_t);

protected:

  BC_TDynamic<Collection_Item, Storage_Manager> fRep;

  virtual void Purge();
  virtual void Add(const Collection_Item&);
  virtual BC_Index Cardinality() const;
  virtual const Collection_Item& Item(BC_Index) const;

};

#endif
