//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCColl.h
//
//  This file contains the declaration of the collection abstract base class
//  and its iterators.

#ifndef BCCOLL_H
#define BCCOLL_H 1

#include "BCType.h"

template<class Collection_Item>
class BC_TCollectionActiveIterator;

template<class Collection_Item>
class BC_TCollectionPassiveIterator;

// Collection abstract base class

template<class Collection_Item>
class BC_TCollection {
public:

  BC_TCollection();
  BC_TCollection(const BC_TCollection<Collection_Item>&);
  virtual ~BC_TCollection();

  virtual BC_TCollection<Collection_Item>& operator=(const BC_TCollection<Collection_Item>&);
  virtual BC_Boolean operator==(const BC_TCollection<Collection_Item>&) const;
  BC_Boolean operator!=(const BC_TCollection<Collection_Item>&) const;
  virtual const Collection_Item& operator[](BC_Index) const = 0;

  virtual void Clear() = 0;
  virtual void Insert(const Collection_Item&) = 0;
  virtual void Insert(const Collection_Item&, BC_Index before) = 0;
  virtual void Append(const Collection_Item&) = 0;
  virtual void Append(const Collection_Item&, BC_Index after) = 0;
  virtual void Remove(BC_Index at) = 0;
  virtual void Replace(BC_Index at, const Collection_Item&) = 0;

  virtual BC_Index Length() const = 0;
  virtual BC_Boolean IsEmpty() const = 0;
  virtual const Collection_Item& First() const = 0;
  virtual const Collection_Item& Last() const = 0;
  virtual BC_Extended_Index Location(const Collection_Item&) const = 0;

protected:

  virtual void Purge() = 0;
  virtual void Add(const Collection_Item&) = 0;
  virtual BC_Index Cardinality() const = 0;
  virtual const Collection_Item& Item(BC_Index) const = 0;

  virtual void Lock();
  virtual void Unlock();

private:

  friend class BC_TCollectionActiveIterator<Collection_Item>;
  friend class BC_TCollectionActiveIterator<Collection_Item>;

};

// Collection iterators

template <class Collection_Item>
class BC_TCollectionActiveIterator {
public:

  BC_TCollectionActiveIterator(const BC_TCollection<Collection_Item>&); 
  ~BC_TCollectionActiveIterator();
  
  void Reset();
  BC_Boolean Next();

  BC_Boolean IsDone() const;
  const Collection_Item* Item() const;
  
protected:

  const BC_TCollection<Collection_Item>& fRepCollection;
  BC_Extended_Index fRepIndex;
  
};

template <class Collection_Item>
class BC_TCollectionPassiveIterator {
public:

  BC_TCollectionPassiveIterator(const BC_TCollection<Collection_Item>&);
  ~BC_TCollectionPassiveIterator();
  
  BC_Boolean Apply(BC_Boolean (*)(const Collection_Item&));
  
protected:

  const BC_TCollection<Collection_Item>& fRepCollection;

};

#endif
