#if !defined(BRWHVIEW_H) && !defined(__BEDRC__)
#define BRWHVIEW_H
//========================================================================================
//
//     File:			BRWHView.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	3/15/93
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================
#ifdef BR_BUILD_WIN

#ifndef BRHVIEW_H
#include "BRHView.h"
#endif

#ifndef BRDEFERM_H
#include "BRDeferM.h"
#endif

#ifndef BRVIEW_H
#include "BRView.h"
#endif

//========================================================================================
// class BR_CViewHelper
//========================================================================================

//========================================================================================
// class BR_CWinViewHelper
//========================================================================================

class BR_CWinViewHelper : public BR_CViewHelper
{
public:
	BR_CWinViewHelper(BR_CView *theView);
	virtual ~BR_CWinViewHelper();

	virtual void	SetEnclosure(BR_CView *enclosure);

	virtual void 	SetFrame(const BR_CRectangle& rRect, BR_Boolean redraw);
	virtual void	SetViewFrame(BR_Boolean redraw);
	virtual void	GetBorderSize(BR_CRectangle& borderSize) const;
	
	virtual void				SetTitle(const BR_TString<BR_Char>& text);
	virtual unsigned long 	GetTitle(BR_TString<BR_Char>& text) const;
	virtual unsigned long 	GetTitleLength() const;

	virtual void	Update();
	virtual void	RefreshRect(const BR_CRectangle &refreshRect);
	virtual void	UnRefreshRect(const BR_CRectangle &refreshRect);
	
	virtual void 	Show(BR_Boolean show = TRUE);
	virtual void	BedShowHideSubviews(BR_Boolean state);

	virtual void	SetFocus();
	virtual void	SetEnable(BR_Boolean state);
	
	void			SetCapture();
	void			ReleaseCapture();
	
	void			SetAutoRedraw(BR_Boolean autoRedraw);

	virtual BR_CBedWinDeferMove *GetDeferMove() const;
	virtual void 	BeginDeferMove();
	virtual void 	EndDeferMove();

	virtual void	LocalToGlobal(BR_CPoint &pt) const;
	virtual void	GlobalToLocal(BR_CPoint &pt) const;

//----------------------------------------------------------------------------------------
//	New methods
//----------------------------------------------------------------------------------------

	virtual void CreateHWND(HWND hParent,
					 		  BR_CView::BedWinClassId classId,
					 		  DWORD style,
					 		  const BR_CRectangle &rSize);

	virtual void 	Paint();

	BR_Boolean 		DoMenuSelect(WORD wParam,
								LONG lParam,
								BR_CMenu &menu,
								LONG &returnValue);	

	void 			DoMouseMessage(BR_CPoint pt,
								WORD wMessage,
								WORD wParam,
								BR_CView::BedWinMouseMessageProc messageProc);

	LONG 			DoControlColor(WORD wParam,
									LONG lParam);
						
	LONG 			DoCompareItem(LONG lParam);
	LONG 			DoDrawItem(LONG lParam);
	void 			DoMeasureItem(LONG lParam);
	void 			DoGetMinMaxInfo(LONG lParam);

	void 			InitMenuPopUp(WORD wParam,
								  BR_CMenuBar &menuBar);

	static HWND 	GetParentHandle(BR_CView *enclosure,
						 			BR_Boolean client = FALSE);

private:
	BR_CBedWinDeferMove *fDeferMove;
	

	BR_SETCLASSNAME(BR_CWinViewHelper);
	
};

//========================================================================================
// class BR_CWinDocWindowHelper
//========================================================================================

class BR_CWinDocWindowHelper : public BR_CWinViewHelper
{
public:
	BR_CWinDocWindowHelper(BR_CView *theView);
	virtual ~BR_CWinDocWindowHelper();


	virtual void CreateHWND(HWND hParent,
					 		  BR_CView::BedWinClassId classId,
					 		  DWORD style,
					 		  const BR_CRectangle &frame);
};

#endif

#endif