#if !defined(BRVALIDF_H) && !defined(__BEDRC__)
#define BRVALIDF_H
//========================================================================================
//
//     File:			BRValidF.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 20, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BREDITCO_H
#include "BREditCo.h"
#endif


//========================================================================================
//	CLASS BR_CValidatedField
//
// An abstract class, used as a bridge between the generic BR_CEditControl and classes
// like BR_CDateField, which look for specific input
//========================================================================================

class BR_CValidatedField : public BR_CEditControl
{
public:
	BR_CValidatedField(BR_CView* enclosure,
					   BR_CBureaucrat* supervisor,
					   const BR_CModule& module,
					   BR_SResource& viewResource);
					   
	BR_CValidatedField(BR_CView* enclosure,
					   BR_CBureaucrat* supervisor,
					   BR_Distance width,
					   BR_Distance height,
					   BR_Coordinate x,
					   BR_Coordinate y,
					   ViewSizing horizontalSizing,
					   ViewSizing verticalSizing,
					   ViewId viewId,
					   ViewStyle style);

	virtual~ BR_CValidatedField();

	virtual BR_Boolean IsValidView();

	virtual BR_Boolean IsValid() = 0;

	BR_SETCLASSNAME(BR_CValidatedField);
};


//========================================================================================
// CLASS BR_CDateField
//========================================================================================

class BR_CDateField : public BR_CValidatedField
{
public:
	BR_CDateField(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  const BR_CModule& module,
				  BR_SResource& viewResource);
				  
	BR_CDateField(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  BR_Distance width,
				  BR_Distance height,
				  BR_Coordinate x,
				  BR_Coordinate y,
				  ViewSizing horizontalSizing,
				  ViewSizing verticalSizing,
				  ViewId viewId,
				  ViewStyle style);

	virtual~ BR_CDateField();

	virtual BR_Boolean IsValid();

	BR_SETCLASSNAME(BR_CDateField);
};


//========================================================================================
// CLASS BR_CTimeField
//========================================================================================

class BR_CTimeField : public BR_CValidatedField
{
public:
	BR_CTimeField(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  const BR_CModule& module,
				  BR_SResource& viewResource);

	BR_CTimeField(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  BR_Distance width,
				  BR_Distance height,
				  BR_Coordinate x,
				  BR_Coordinate y,
				  ViewSizing horizontalSizing,
				  ViewSizing verticalSizing,
				  ViewId viewId,
				  ViewStyle style);

	virtual~ BR_CTimeField();

	virtual BR_Boolean IsValid();

	BR_SETCLASSNAME(BR_CTimeField);
};


//========================================================================================
//	CLASS BR_CNumberField
//
// This instance creates and manages a BR_CEditControl that only accepts numbers (and
// related symbols) as input
//========================================================================================

class BR_CNumberField : public BR_CValidatedField
{
public:
	BR_CNumberField(BR_CView* enclosure,
					BR_CBureaucrat* supervisor,
					const BR_CModule& Module,
					BR_SResource& viewResource);

	BR_CNumberField(BR_CView* enclosure,
					BR_CBureaucrat* supervisor,
					BR_Distance width,
					BR_Distance height,
					BR_Coordinate x,
					BR_Coordinate y,
					ViewSizing horizontalSizing,
					ViewSizing verticalSizing,
					ViewId viewId,
					ViewStyle style);

	virtual~ BR_CNumberField();

	virtual BR_Boolean DoKey(Key key,
							 unsigned short repeatCount,
							 BR_Boolean callSupervisor = TRUE);
	virtual BR_Boolean IsValid();

	long GetLong() const;
	short GetShort() const;
	BR_Float GetFloat() const;

	BR_SETCLASSNAME(BR_CNumberField);
};



#endif
