#if !defined(BRUTLTY_H) && !defined(__BEDRC__)
#define BRUTLTY_H
//========================================================================================
//
//     File:			BRUtlty.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/16/90
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef __INC_WINDOWS
#define NOGDICAPMASKS
#define NOVIRTUALKEYCODES
#define NOWINMESSAGES
#define NOWINSTYLES
#define NOSYSMETRICS
#define NOMENUS
#define NOICONS
#define NOKEYSTATES
#define NOSYSCOMMANDS
#define NORASTEROPS
#define NOSHOWWINDOW
#define NOATOM
#define NOCLIPBOARD
#define NOCOLOR
#define NOCTLMGR
#define NODRAWTEXT
#define NOUSER
#define NOMB
#define NOMETAFILE
#define NOMINMAX
#define NOMSG
#define NOOPENFILE
#define NOSCROLL
#define NOSOUND
#define NOTEXTMETRIC
#define NOWH
#define NOWINOFFSETS
#define NOCOMM
#define NOKANJI
#define NOHELP
#define NOPROFILER
#define NODEFERWINDOWPOS

#include <windows.h>
#endif

#ifndef BRVM_H
#include "BRVM.h"
#endif

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifdef __cplusplus 
extern "C" {
#endif


DWORD  FAR PASCAL hugememmov(LPSTR pDestination, DWORD dwDestOffset, LPSTR pSource, DWORD dwSrcOffset, DWORD nChars);
LPSTR  FAR PASCAL GetOffsetPointer(LPSTR lpPointer, const DWORD dwOffset);
BR_Char*   FAR PASCAL  lstrchr(BR_Char* pString, char ch);

#ifdef BR_BUILD_WIN

WORD PASCAL BCLDosLSeek(UINT hFileHandle,
						LONG cbFilePos,
						UINT nSeekMode,
						DWORD* pcbNewPos);
						
WORD PASCAL BCLDosCreate(const char* fileName, UINT* fileHandle);
	/* This creates the file AND OPENS IT! */

WORD PASCAL BCLDosDelete(const char* fileName);

WORD PASCAL BCLDosOpenFile(const char* pzName, UINT nOpenMode, UINT* pFileHandle);
WORD PASCAL BCLDosCloseFile(UINT hFileHandle);

WORD PASCAL BCLDosReadFile(UINT hFile,
						   DWORD cbSize,
						   void* pBuffer,
						   DWORD* pcbCouldRead);
WORD PASCAL BCLDosWriteFile(UINT hFile,
						    DWORD cbSize,
						    void* pBuffer,
						    DWORD* pcbCouldWrite);

char* unmangle_ident(char* ident);
	/* Zortech unmangler.  The body is in BRUnmang.c */

BR_Char* FAR PASCAL lstrchr(BR_Char* pString, char ch);

#ifdef BR_DEBUG
void FAR PASCAL BCLGetCallerInfo(HANDLE* phModule,
								 char* zModule,
								 WORD* pwSegment,
								 WORD* pwOffset,
								 unsigned n_TraceDepth);
	/* Crawls the stack and returns caller info as follows: *phModule is the Windows
	  module handle, zModule (if not NULL) receives the name, *pwSegment is the
	  ordinal segment number and pwOffset is the offset within that segment.
	  n_TraceDepth specifies how far to crawl. */
	
void FAR PASCAL BCLGetModuleName(HANDLE fModule,
								 char* zModule);
	/* Returns name of a Windows module identified by handle fModule.
	  Module names do not exceed 8 characters. */
	  
BR_Boolean BCLSymFileFindAddress(void* pSymData,
						   WORD wSeg,
						   WORD fOffset,
						   BYTE cbMaxLen,
						   char* pzName);
	/* Searches a symbol in .SYM file data pointed by pSymData.  This is in C because
	  I need huge pointers. */

#endif
#endif

#ifdef __cplusplus
}
#endif

#endif
