#if !defined(BRSTRLIS_H) && !defined(__BEDRC__)
#define BRSTRLIS_H
//========================================================================================
//
//     File:			BRStrLis.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	November 21, 1990
//
//     COPYRIGHT 1990 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCCOLLU_H
#include "BCCollU.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif


//========================================================================================
// CLASS BR_CStringList
//========================================================================================

class BR_CStringList : public BR_CObject
{
public:
	BR_CStringList();
	BR_CStringList(const BR_CStringList& StringList);
	virtual~ BR_CStringList();

	virtual BR_Boolean GetString(BC_Index itemNo,
								 BR_TString<BR_Char>& Buffer) const;
	virtual BR_Boolean AdoptString(BC_Index itemNo,
								  const BR_TString<BR_Char>& Buffer);
	virtual BR_Boolean AddString(const BR_TString<BR_Char>& Buffer);
	virtual BC_Extended_Index FindString(const BR_TString<BR_Char>& strFind) const;
	virtual BR_TString<BR_Char>* RemoveString(BC_Index itemNo);
	virtual BR_TString<BR_Char>* RemoveLastString();
	virtual void DeleteAll();
	virtual BC_Index Length() const;
	
	BR_CStringList& operator=(const BR_CStringList& StringList);
	const BR_TString<BR_Char>* GetString(BC_Index i) const;
	BR_TString<BR_Char>* GetString(BC_Index i);
	BR_TString<BR_Char>* operator[](BC_Index i) const;

	BR_SETCLASSNAME(BR_CStringList);
	
private:
	BC_TUnboundedCollection<BR_TString<BR_Char> *, BC_CUnmanaged> fStringList;
	
};

//----------------------------------------------------------------------------------------
// BR_CStringList::GetString
//----------------------------------------------------------------------------------------

inline const BR_TString<BR_Char>* BR_CStringList::GetString(BC_Index i) const
{
	return fStringList[i];
}

//----------------------------------------------------------------------------------------
// BR_CStringList::GetString
//----------------------------------------------------------------------------------------

inline BR_TString<BR_Char>* BR_CStringList::GetString(BC_Index i)
{
	return fStringList[i];
}

//----------------------------------------------------------------------------------------
// BR_CStringList::operator[]
//----------------------------------------------------------------------------------------

inline BR_TString<BR_Char>* BR_CStringList::operator[](BC_Index i) const
{
	return fStringList[i];
}

#endif
