#if !defined(BRSTREAM_H) && !defined(__BEDRC__)
#define BRSTREAM_H
//========================================================================================
//
//     File:			BRStream.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 22, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

//========================================================================================
//	CLASS BR_CStream
//========================================================================================

class BR_CStream : public BR_CObject
{
public:
	typedef unsigned long int StreamSize;
	typedef unsigned long int StreamIndex;
	typedef unsigned long int StreamBufferSize;

	virtual~ BR_CStream();
	virtual StreamSize GetLength() const;
	virtual BR_Boolean SetLength(StreamSize newLength);
	virtual StreamIndex GetPosition() const;
	virtual StreamIndex SetPosition(StreamIndex newPosition);

	virtual BR_Boolean Read(void* buffer,
							StreamBufferSize& nBytes) = 0;

	virtual BR_Boolean Write(void* buffer,
							 StreamBufferSize& nBytes) = 0;

protected:
	BR_CStream();

private:
	StreamIndex fCurrentStreamIndex;							//Current index into the stream
	StreamSize fCurrentStreamSize;						//Current length of the stream

	BR_SETCLASSNAME(BR_CStream);
};

#endif
