#if !defined(BRSTATXT_H) && !defined(__BEDRC__)
#define BRSTATXT_H
//========================================================================================
//
//     File:		BRStaTxt.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	10/21/90
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRVIEW_H
#include "BRView.h"
#endif

#ifndef   BRTXSTRE_H
#include "BRTxStre.h"
#endif

#ifndef   BRGRCOMM_H
#include "BRGrComm.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CTextSTream;

//========================================================================================
//	STRUCT BR_SStaticTextRes
//========================================================================================

struct BR_SStaticTextRes : BR_SViewResource
{
	BR_SRectangle 	fTextBounds;
    char			fInitialTextString[128];
    unsigned long	fMaximumNumberOfLines;
};


//========================================================================================
//	CLASS BR_CStaticText
//========================================================================================

class BR_CStaticText : public BR_CView
{
public:
    static const unsigned long kRemainingCharacters;
	
	typedef long int LinePosition;
	typedef unsigned long int LineNumber;
	typedef unsigned long int ColumnNumber;
	typedef unsigned long int PageNumber;
	typedef unsigned long int CharacterCount;
	typedef unsigned long int LineCount;

	typedef int Justification;
	enum JustificationConstants
	{
		kJustifyLeft, kJustifyRight, kJustifyCenter
	};
	
	BR_CStaticText(BR_CView* enclosure,
				   BR_CBureaucrat* supervisor,
				   BR_Distance width,
				   BR_Distance height,
				   BR_Coordinate x,
				   BR_Coordinate y,
				   ViewSizing horizontalSizing,
				   ViewSizing verticalSizing,
				   ViewUnits viewUnits,
				   const BR_CRectangle& textBounds);

	BR_CStaticText(BR_CView* enclosure,
				   BR_CBureaucrat* supervisor,
				   const BR_CModule& resourceModule,
				   BR_SResource& viewResource);

	virtual ~BR_CStaticText();

	// Inherited virtual methods
	virtual BR_CFont* SetViewFont(BR_CFont* newFont);
	virtual void PrintPage(const BR_CRectangle& pageRectangle,
						   PageNumber nPage);

	// New virtual methods
	virtual void AdjustTextBounds();
	virtual void SetColor(BR_CColor newColor);
	virtual BR_Boolean DrawLineOfText(LineNumber lineNumber,
									  ColumnNumber columnNumber = 0,
									  CharacterCount numberOfCharacters = kRemainingCharacters);
	virtual void SetTextStream(BR_CTextStream* newTextStream);
	virtual BR_Distance GetLineHeight(LineNumber lineNumber) const;
	virtual BR_Distance GetLineWidth(LineNumber lineNumber,
									 ColumnNumber columnNumber = 0,
									 CharacterCount numberOfCharacters = kRemainingCharacters) const;

	virtual BR_CPoint GetLineStart(LineNumber lineNumber) const;
	virtual BR_Coordinate GetLineX(LineNumber lineNumber) const;
	virtual BR_Coordinate GetLineY(LineNumber lineNumber) const;
	virtual LineCount GetLineCount() const;
	virtual CharacterCount GetLine(BR_TString<BR_Char>& textBuffer,
							   LineNumber lineNumber) const;
	const BR_TString<BR_Char>* GetLine(LineNumber lineNumber) const;
	virtual void GetRectOfLine(BR_CRectangle& lineRectangle,
							   LineNumber lineNumber,
							   ColumnNumber columnNumber = 0,
							   CharacterCount numberOfCharacters = kRemainingCharacters) const;
	virtual void GetRectOfLineRange(BR_CRectangle& linesRectangle,
									LineNumber beginningLineNumber,
									LineNumber endingLineNumber) const;

	virtual CharacterCount GetLineLength(LineNumber lineNumber) const;
	virtual LineNumber GetLineAtPoint(const BR_CPoint& point) const;
	virtual void GetLinesInRectangle(const BR_CRectangle& rectangle,
									 LineNumber& startLine,
									 LineCount& numberOfLines) const;

	virtual BR_Boolean InsertCharacter(LineNumber lineNumber,
								   ColumnNumber columnNumber,
								   BR_Char gCharacter);
	virtual BR_Boolean DeleteCharacter(LineNumber lineNumber,
								   ColumnNumber columnNumber,
								   CharacterCount numberOfCharacters,
								   BR_Boolean& deletedAnEOL);
	virtual BR_Boolean InsertString(LineNumber lineNumber,
									ColumnNumber columnNumber,
									const BR_TString<BR_Char>& string);
	virtual BR_Boolean InsertLine(LineNumber lineNumber,
								  BR_TString<BR_Char>& string);
	virtual void SetFont(const BR_TString<BR_Char>& stringFontName,
						 BR_CFont::FontSize fFontSize,
						 BR_CFont::FontStyle fFontStyle,
						 BR_CColor fontColor);

	virtual void SetFontName(const BR_TString<BR_Char>& fontName);
	virtual void SetFontStyle(BR_CFont::FontStyle fFontStyle);
	virtual void SetFontSize(BR_CFont::FontSize fFontSize);
	virtual void SetLineHeight(BR_Distance lineHeight);
	virtual void SetJustification(Justification justification,
								  BR_Boolean redraw = TRUE);

	// New methods
	BR_CTextStream* GetTextStream() const;
	void GetFontAttributes(BR_TString<BR_Char>& fontName,
						   BR_CFont::FontSize& fFontSize,
						   BR_CFont::FontStyle& fFontStyle,
						   BR_CColor& fontColor) const;
	LineNumber GetLastLineNumber() const;
	BR_Distance GetLineHeight() const;
	Justification GetJustification() const;

	void	GetTextBounds(BR_CRectangle &textBounds) const;
	void	SetTextBounds(const BR_CRectangle &textBounds);
	
protected:
	virtual void AdjustToFont();

	// So that we only print one Page wide
	virtual unsigned long GetNumPageStrips(const BR_CPoint& printingPageSize,
										   BR_Boolean verticalStrips) const;
	// So that printing doesn't break lines
	virtual void AdjustPrintingPageSize(BR_CPoint& printingPageSize) const;

	// Inherited virtual methods
	virtual void ComputeViewFrame(const BR_CRectangle &oldEnclosureInterior,
									const BR_CRectangle &newEnclosureInterior, 
									BR_CRectangle &newFrame);
									
	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& area);
	virtual void UpdateLines(LineNumber beginningLineNumber,
							 LineNumber endingLineNumber);


private:
	BR_CRectangle		fTextBounds;
	LineCount 			fLineCount;					// Number of lines.
	BR_Distance 		fLineHeight;				// Height of a line.
	BR_CTextStream* 	fTextStream;				// This instance's text stream.
	BR_Boolean 			fDeleteFont;
	BR_CDynamicCharString 	fTextString;
	Justification 		fJustification;

	void InitStaticText(const BR_TString<BR_Char>& textString);

	BR_SETCLASSNAME(BR_CStaticText);
};

//----------------------------------------------------------------------------------------
// BR_CStaticText::GetTextBounds
//----------------------------------------------------------------------------------------

inline void BR_CStaticText::GetTextBounds(BR_CRectangle &textBounds) const
{
	textBounds = fTextBounds;
}

//----------------------------------------------------------------------------------------
// BR_CStaticText::SetTextBounds
//----------------------------------------------------------------------------------------

inline void BR_CStaticText::SetTextBounds(const BR_CRectangle &textBounds)
{
	fTextBounds = textBounds;
}


#endif


