#if !defined(BRSTATUS_H) && !defined(__BEDRC__)
#define BRSTATUS_H
//========================================================================================
//
//     File:			BRStatus.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	November 17, 1990
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef BRAPPDES_H
#include "BRAppDes.h"
#endif

//========================================================================================
//	CLASS BR_CStatusBar
//========================================================================================

class BR_CStatusBar : public BR_CView
{
public:
	BR_CStatusBar(BR_CAppDesktop *enclosure,
				  BR_Distance thickness,
				  BR_Distance textOffset,
				  BR_CAppDesktop::DesktopPane whichPane);

	BR_CStatusBar(BR_CView *enclosure,
				  BR_CBureaucrat *supervisor,
				  const BR_CModule &module,
				  BR_SResource &viewResource);

	virtual				~BR_CStatusBar();

	// Inherited
	virtual void 			Draw(BR_CCanvas &canvas, const BR_CRectangle &area);
	virtual void 			SetText(const BR_TString<BR_Char> &text, BR_Boolean redraw=TRUE);
	virtual BR_Boolean 	SetFocus();

	void 					SetDrawOffset(BR_Distance offset);

private:
	BR_Distance 			fTextOffset;			// Offset of text within the status bar
	BR_CColor 				fOldTextColor;			// The old text color that is saved when we switch to ours
	BR_CDynamicCharString 		*fText;					// Status bar caption

	void 					DrawBarText(BR_CCanvas &canvas);

	BR_SETCLASSNAME(BR_CStatusBar);
};

//----------------------------------------------------------------------------------------
//	BR_CStatusBar::SetDrawOffset
//----------------------------------------------------------------------------------------
inline void BR_CStatusBar::SetDrawOffset(BR_Distance offset)
{
	fTextOffset = offset;
}

#endif

