#ifndef BRSCROLE_H
#define BRSCROLE_H
//========================================================================================
//
//     File:			BRScrolE.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	4/4/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRRECT_H
#include "BRRect.h"
#endif

#ifndef   BRDEBUG_H
#include "BRDebug.h"
#endif

#ifndef   BRCMDIDS_H
#include "BRCmdIds.h"
#endif

#ifndef   BRSCROLB_H
#include "BRScrolB.h"
#endif

//========================================================================================
// CLASS BR_CScrollEvent
//========================================================================================

class BR_CScrollEvent
{
public:
	typedef short int ScrollEventCommand;
	enum ScrollEventCommandConstants
	{
		kScrollEventCommandAutoScroll,
		kScrollEventCommandToAPointLocation,
		kScrollEventCommandToAStepLocation,
		kScrollEventCommandToAStepPosition,
		kScrollEventCommandByStepDistance,
		kScrollEventCommandMaximum,
		kScrollEventCommandAPage,
		kScrollEventCommandALine,
		kScrollEventCommandThumbTrack,
		kScrollEventCommandEndThumbTrack
	};

public:
	BR_CScrollEvent(ScrollEventCommand command);
	BR_CScrollEvent(BR_CScrollBar::ScrollBarCommand scrollBarCommand,
					BR_CPoint::XYSelector orientation,
					BR_CScrollBar::StepPosition stepPosition);
	BR_CScrollEvent(BR_CScrollBar::StepPosition horizontal,
					BR_CScrollBar::StepPosition vertical);
	BR_CScrollEvent(const BR_CPoint& point);
	BR_CScrollEvent(BR_CBureaucrat::Key thekey,
					BR_CPoint::XYSelector orientation);

	ScrollEventCommand GetCommand() const;
	BR_CPoint::XYSelector GetOrientation() const;
	BR_CScrollBar::ScrollDirection GetDirection() const;
	BR_CPoint GetPointLocation() const;
	const BR_CScrollBar::StepPosition* GetStepLocation() const;
	const BR_CScrollBar::StepDistance* GetStepDistance() const;
	BR_CScrollBar::StepPosition GetStepPosition() const;

private:
	void InitScrollEvent(ScrollEventCommand command,
						 BR_CPoint::XYSelector orientation,
						 BR_CScrollBar::ScrollDirection direction);

	ScrollEventCommand fCommand;
	BR_CPoint::XYSelector fOrientation;
	BR_CScrollBar::ScrollDirection fDirection;
	union
	{
		BR_Coordinate fPointLocation[2];
		BR_CScrollBar::StepPosition fStepLocation[2];
		BR_CScrollBar::StepDistance fStepDistance[2];
		BR_CScrollBar::StepPosition fStepPosition;
	};
};

//----------------------------------------------------------------------------------------
// BR_CScrollEvent::GetCommand
//----------------------------------------------------------------------------------------

inline BR_CScrollEvent::ScrollEventCommand BR_CScrollEvent::GetCommand() const
{
	return fCommand;
}

//----------------------------------------------------------------------------------------
// BR_CScrollEvent::GetOrientation
//----------------------------------------------------------------------------------------

inline BR_CPoint::XYSelector BR_CScrollEvent::GetOrientation() const
{
	return fOrientation;
}

//----------------------------------------------------------------------------------------
// BR_CScrollEvent::GetDirection
//----------------------------------------------------------------------------------------

inline BR_CScrollBar::ScrollDirection BR_CScrollEvent::GetDirection() const
{
	return fDirection;
}

//----------------------------------------------------------------------------------------
// BR_CScrollEvent::GetPointLocation
//----------------------------------------------------------------------------------------

inline BR_CPoint BR_CScrollEvent::GetPointLocation() const
{
	return BR_CPoint(fPointLocation[BR_CPoint::kX], fPointLocation[BR_CPoint::kY]);
}

//----------------------------------------------------------------------------------------
// BR_CScrollEvent::GetStepLocation
//----------------------------------------------------------------------------------------

inline const BR_CScrollBar::StepPosition* BR_CScrollEvent::GetStepLocation() const
{
	return fStepLocation;
}

//----------------------------------------------------------------------------------------
// BR_CScrollEvent::GetStepDistance
//----------------------------------------------------------------------------------------

inline const BR_CScrollBar::StepDistance* BR_CScrollEvent::GetStepDistance() const
{
	return fStepDistance;
}

//----------------------------------------------------------------------------------------
// BR_CScrollEvent::GetStepPosition
//----------------------------------------------------------------------------------------

inline BR_CScrollBar::StepPosition BR_CScrollEvent::GetStepPosition() const
{
	return fStepPosition;
}

#endif
