#if !defined(BRPRINTM_H) && !defined(__BEDRC__)
#define BRPRINTM_H
//========================================================================================
//
//     File:			BRPrintM.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11 Sept, 1992
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRPRINFO_H
#include "BRPrInfo.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__PRINTING__)
#include <Printing.h>
#endif

#ifdef BR_BUILD_MAC
//========================================================================================
//	Class BR_CMacPrintManager
//========================================================================================

class BR_CMacPrintManager : public BR_CObject
{
public:
	static void PrOpen();
	static void PrClose();
	static void PrintDefault(THPrint hPrint);
	static Boolean PrValidate(THPrint hPrint);
	static Boolean PrStlDialog(THPrint hPrint);
	static Boolean PrJobDialog(THPrint hPrint);
	static TPPrDlg PrStlInit(THPrint hPrint);
	static TPPrDlg PrJobInit(THPrint hPrint);
	static void PrJobMerge(THPrint hPrintSrc,
						   THPrint hPrintDst);
	static Boolean PrDlgMain(THPrint hPrint,
							 PDlgInitProcPtr pDlgInit);
	static TPPrPort PrOpenDoc(THPrint hPrint,
							  TPPrPort pPrPort,
							  Ptr pIOBuf);
	static void PrOpenPage(TPPrPort pPrPort,
						   TPRect pPageFrame);
	static void PrCloseDoc(TPPrPort pPrPort,
						   BR_Boolean okToThrowExceptions = TRUE);
	static void PrClosePage(TPPrPort pPrPort,
							BR_Boolean okToThrowExceptions = TRUE);
	static void PrPicFile(THPrint hPrint,
									TPPrPort pPrPort,
									Ptr pIOBuf,
									Ptr pDevBuf,
									TPrStatus* prStatus);
	static short PrError();
	static void PrSetError(short iErr);
	static void PrGeneral(Ptr pData);
	static void ThrowNativePrintError(short theError);

private:
	BR_CMacPrintManager();
	~BR_CMacPrintManager();

	static short fOpenCount;
	static BR_Boolean fDocOpen;
	static BR_Boolean fPageOpen;
	
	BR_SETCLASSNAME(BR_CMacPrintManager);
};
#endif

#ifdef BR_BUILD_WIN
//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CPrinterInfo;

//========================================================================================
//	Class BR_CHDCPrinter
//========================================================================================

class BR_CWinPrintManager : public BR_CObject
{
public:
	enum
	{
		kWantDC = FALSE, kWantIC = TRUE
	};


	BR_CWinPrintManager(const BR_CPrinterInfo& thePrinterInfo,
						BR_Boolean icOrDc = kWantDC);
	virtual~ BR_CWinPrintManager();

	HDC BR_CWinPrintManager::GetHDC() const;

	int GetDeviceCaps(int nIndex) const;
	void Escape(int iCode,
				int nCount,
				const LPSTR lpInData,
				const LPSTR lpOutData,
				BR_Boolean okToThrowExceptions = TRUE) const;

private:
	HDC fHDC;

	BR_SETCLASSNAME(BR_CWinPrintManager);
};
#endif

//========================================================================================
//	Class BR_XPrint
//========================================================================================

class BR_XPrint : public BR_XBedException
{
public:
	typedef unsigned long int PrintError;
	
	BR_XPrint(PrintError theError);
	BR_XPrint();
	
	virtual ~BR_XPrint();
	
	_BR_EXCEPTION_DEFINE(BR_XPrint);
};

//========================================================================================
//	Class BR_XPrintOutOfDiskSpace
//========================================================================================

class BR_XPrintOutOfDiskSpace : public BR_XPrint
{
public:
	BR_XPrintOutOfDiskSpace();
	virtual ~BR_XPrintOutOfDiskSpace();
	
	_BR_EXCEPTION_DEFINE(BR_XPrintOutOfDiskSpace);
};

//========================================================================================
//	Class BR_XPrintOutOfMemory
//========================================================================================

class BR_XPrintOutOfMemory: public BR_XPrint
{
public:
	BR_XPrintOutOfMemory();
	virtual ~BR_XPrintOutOfMemory();
	
	_BR_EXCEPTION_DEFINE(BR_XPrintOutOfMemory);
};

//========================================================================================
//	Class BR_XPrintOutOfMemory
//========================================================================================

class BR_XPrintUserCancelled: public BR_XPrint
{
public:
	BR_XPrintUserCancelled();
	virtual ~BR_XPrintUserCancelled();
	
	_BR_EXCEPTION_DEFINE(BR_XPrintUserCancelled);
};

//========================================================================================
//	Class BR_XPrintOutOfMemory
//========================================================================================

class BR_XPrintErrorSavingSpoolFile: public BR_XPrint
{
public:
	BR_XPrintErrorSavingSpoolFile();
	virtual ~BR_XPrintErrorSavingSpoolFile();
	
	_BR_EXCEPTION_DEFINE(BR_XPrintErrorSavingSpoolFile);
};


//========================================================================================
//	Class BR_XPrintOutOfMemory
//========================================================================================

class BR_XPrintNoPrinter: public BR_XPrint
{
public:
	BR_XPrintNoPrinter();
	virtual ~BR_XPrintNoPrinter();
	
	_BR_EXCEPTION_DEFINE(BR_XPrintNoPrinter);
};

//========================================================================================
//	Class BR_XPrintOutOfMemory
//========================================================================================

class BR_XPrintMarginsTooBigForPaper: public BR_XPrint
{
public:
	BR_XPrintMarginsTooBigForPaper(const BR_CRectangle& margins,
								BR_CPrinterInfo::Scaler numerator,
								BR_CPrinterInfo::Scaler denominator);
	virtual ~BR_XPrintMarginsTooBigForPaper();
	
	void GetMargins(BR_CRectangle& margins) const;
	void GetScaling(BR_CPrinterInfo::Scaler& numerator,
					BR_CPrinterInfo::Scaler& denomenator) const;
	
	_BR_EXCEPTION_DEFINE(BR_XPrintMarginsTooBigForPaper);
	
private:
	BR_CRectangle fMargins;
	BR_CPrinterInfo::Scaler fScalingNum;
	BR_CPrinterInfo::Scaler fScalingDen;
};

//========================================================================================
//	Class BR_XPrintOutOfMemory
//========================================================================================

class BR_XPrintNoPagesInRange: public BR_XPrint
{
public:
	BR_XPrintNoPagesInRange();
	virtual ~BR_XPrintNoPagesInRange();
	
	_BR_EXCEPTION_DEFINE(BR_XPrintNoPagesInRange);
};


#endif