#if !defined(BRPRDLGS_H) && !defined(__BEDRC__)
#define BRPRDLGS_H
//========================================================================================
//
//     File:		BRPrDlgs.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	July 17, 1991
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDLGDIR_H
#include "BRDlgDir.h"
#endif

#ifndef BRBUREAU_H
#include "BRBureau.h"
#endif

#ifndef BRPRINFO_H
#include "BRPrInfo.h"
#endif

//========================================================================================
//	Forward class declaration
//========================================================================================

class BR_CPrinter;
class BR_CApplication;
class BR_CDocument;

//========================================================================================
// CLASS BR_CPrintingProgressDialog
//========================================================================================

class BR_CPrintingProgressDialog : public BR_CDialogDirector
{
public:
	BR_CPrintingProgressDialog(BR_CDocument* itsSupervisor,
							   BR_CPrinter* thePrinter);
	virtual~ BR_CPrintingProgressDialog();

	virtual BR_Boolean DoCommand(CommandId theId,
								 BR_CObject* theNotifier,
								 BR_Boolean callSupervisor = TRUE);
	virtual void DoIdle() const;

	virtual void NewWindow();

	virtual void StartPage(BR_CPrinterInfo::Page pageNumber);
	// called JUST before starting to Draw the contents of the Page

	virtual void EndPage(BR_CPrinterInfo::Page pageNumber);
	// called JUST after finishing drawing the contents

	BR_CDialogBox* GetDialogBox() const;
	BR_Boolean AreCurrentlyDrawingPage() const;
	BR_Boolean Aborted() const;

	static BR_CPrintingProgressDialog* fgCurrent;//??Internal??

protected:
	virtual void SetPageNumber(BR_CPrinterInfo::Page nPage);

private:
	BR_CDocument* fDocument;
	BR_CPrinter* fPrinter;
	BR_CDialogBox* fDialogBox;
	BR_Boolean fCurrentlyDrawingPage;
	BR_Boolean fAborted;

	BR_SETCLASSNAME(BR_CPrintingProgressDialog);
};

//========================================================================================
// CLASS BR_CPrinterPrintSetup
//========================================================================================

class BR_CPrinterPrintSetup : public BR_CDialogDirector
{
public:
	BR_CPrinterPrintSetup(BR_CDocument* itsDocument,
						  BR_CPrinterInfo* itsPrinterInfo);
	virtual~ BR_CPrinterPrintSetup();

	BR_CBureaucrat::CommandId GetResult() const;

	virtual void NewWindow();

	BR_Boolean PrintSetupChanged() const;

protected:
	CommandId fResultCommand;
	BR_Boolean fSetupChanged;
	BR_CPrinterInfo* fPrinterInfo;
	BR_CDocument* fDocument;

#ifdef BR_BUILD_WIN
public:
	// this constructor won't work because fPrinterInfo
	// is uninitialized
	BR_CPrinterPrintSetup::BR_CPrinterPrintSetup(BR_CBureaucrat* itsSupervisor,
												 BR_CView* itsEnclosure,
												 BR_CModule* itsModule,
												 BR_ResourceId itsResourceId);
#endif

	BR_SETCLASSNAME(BR_CPrinterPrintSetup);
};

//----------------------------------------------------------------------------------------
// BR_CPrinterPrintSetup::GetResult
//----------------------------------------------------------------------------------------

inline BR_CBureaucrat::CommandId BR_CPrinterPrintSetup::GetResult() const
{
	return fResultCommand;
}

//----------------------------------------------------------------------------------------
// BR_CPrinterPrintSetup::GetResult
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CPrinterPrintSetup::PrintSetupChanged() const
{
	return fSetupChanged;
}


//========================================================================================
// CLASS BR_CPrintJobDialog: A class for creating dialogs to let the user choose print
// fOptions such as 'Number of pages,' 'Number of copies,' etc.
//========================================================================================

class BR_CPrintJobDialog : public BR_CDialogDirector
{
public:
	BR_CPrintJobDialog(BR_CDocument* itsDocument,
					   BR_CPrinterInfo* itsPrinterInfo);
	virtual~ BR_CPrintJobDialog();

	BR_CBureaucrat::CommandId GetResult() const;

	virtual void NewWindow();

	BR_Boolean PrintSetupChanged() const;

protected:
	CommandId fResultCommand;
	BR_Boolean fSetupChanged;
	BR_CPrinterInfo* fPrinterInfo;

#ifdef BR_BUILD_WIN
public:
	BR_CPrintJobDialog::BR_CPrintJobDialog(BR_CBureaucrat* itsSupervisor,
										   BR_CView* itsEnclosure,
										   BR_CModule* itsModule,
										   BR_ResourceId itsResourceId);
	// this constructor won't work because fPrinterInfo is uninitialized
#endif

	BR_SETCLASSNAME(BR_CPrintJobDialog);
};

//----------------------------------------------------------------------------------------
// BR_CPrintJobDialog::GetResult
//----------------------------------------------------------------------------------------

inline BR_CBureaucrat::CommandId BR_CPrintJobDialog::GetResult() const
{
	return fResultCommand;
}

//----------------------------------------------------------------------------------------
// BR_CPrintJobDialog::PrintSetupChanged
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CPrintJobDialog::PrintSetupChanged() const
{
	return fSetupChanged;
}

#endif

