#ifndef BROPENDH_H
#define BROPENDH_H

//========================================================================================
//
//     File:		BROpenDH.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	2/25/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRBEDEXC_H
#include "BRBedExc.h"
#endif

#ifndef BRCHRSTR_H
#include "BRChrStr.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__STANDARDFILE__)
#include "StandardFile.h"
#endif

#if defined(BR_BUILD_WIN) && !defined(_INC_WINDOWS)
#include "Windows.h"
#endif

#ifndef BRAUTODE_H
#include "BRAutoDe.h"
#endif


//========================================================================================
// Constants
//========================================================================================
const short kMaximumNumberOfFileTypes = 4;


//========================================================================================
// Forward class declarations
//========================================================================================
class BR_CModule;
class BR_CFileFilter;



//========================================================================================
//	BR_SSFPInfoResource
//
//  Resource structure for the BR_CSFPDialogInfo class.  This loads in the filter list
//    specified by fFileFilterListID and the default file name and message strings.  If
//    fFileFilterListID is 0 then no filter list is loaded.
//========================================================================================

struct BR_SSFPInfoResource
{
	BR_ResourceId fFileFilterListID;
	char fDefaultFileName[64];
	char fMessageString[64];
};




//========================================================================================
//	BR_CSFPDialogInfo
//
//	This class is a helper class which encapsulates information for the BR_COpenFileDialog
//    and its subclasses.
//========================================================================================

class BR_CSFPDialogInfo : public _BR_CAutoDestructObject
{
public:
	BR_CSFPDialogInfo();
	BR_CSFPDialogInfo(const BR_CModule& resourceModule,
					   BR_ResourceId resourceID);

	virtual ~BR_CSFPDialogInfo();


	void SetCurrentDirectory(const BR_TString<BR_Char>& pathName);

	void LoadFilterList(const BR_CModule& resourceModule,
						BR_ResourceId multiStringTableID);

	void* GetCallbackData() const;
	void SetCallbackData(void* newCallbackData);

	void SetDefaultFileName(const BR_TString<BR_Char>& defaultName);
	void GetDefaultFileName(BR_TString<BR_Char>& defaultName) const;

	void SetMessageString(const BR_TString<BR_Char>& messageString);
	void GetMessageString(BR_TString<BR_Char>& messageString) const;

private:
	// Don't want copy constructor and assignment operator.
	BR_CSFPDialogInfo(const BR_CSFPDialogInfo& dialogInfo);
	BR_CSFPDialogInfo& operator= (const BR_CSFPDialogInfo& dialogInfo);
	
	void* fCallbackData;
	BR_CDynamicCharString fDefaultFileName;
	BR_CDynamicCharString fMessageString;

#ifdef BR_BUILD_WIN
public:

	void WinAddFileFilter(const BR_TString<BR_Char>& filterName,
					   const BR_TString<BR_Char>& filterPatterns);
	void WinAddFileFilter(const BR_CFileFilter& filter);

	void BedWinGetFilterString(BR_CDynamicCharString& filterString);
	long WinGetFlags() const;
	void WinSetFlags(long newFlags);

	virtual CALLBACK BedWinGetDialogHook() const;

private:
	BR_CDynamicCharString fWinFilterList;
	BR_CDynamicCharString fWinWorkingDirectory;
	long			  fWinDialogFlags;


#endif

#ifdef BR_BUILD_MAC	
public:
	virtual ProcPtr BedMacGetDialogHook() const;
	virtual ProcPtr BedMacGetFileFilterProc() const;
	virtual ProcPtr BedMacGetEventFilterProc() const;
	virtual ProcPtr BedMacGetActivationProc() const;
	virtual short* BedMacGetActivationList() const;

	Point BedMacGetDialogLocation() const;
	void MacSetDialogLocation(Point dialogLocation);

	virtual void MacAddFileType(OSType fileType);
	virtual void MacAddFileType(const SFTypeList* typeList,
								short numberOfTypes);

	SFTypeList* BedMacGetTypeList() const;
	short BedMacGetNumberOfFileTypes() const;

protected:
	SFTypeList* fMacTypeList;
	short fMacNumberOfTypes;
	
private:
	Point fDialogLocation;

#endif

};



//========================================================================================
//	CLASS BR_XMacTooManyFileTypes
//========================================================================================


class BR_XMacTooManyFileTypes : public BR_XBedException
{
public:
	BR_XMacTooManyFileTypes(unsigned long numberOfTypes);
	virtual ~BR_XMacTooManyFileTypes();
	
	unsigned long GetNumberOfTypes() const;
	
	_BR_EXCEPTION_DEFINE(BR_XMacTooManyFileTypes);
private:
	unsigned long fNumberOfTypesRequested;
};




//========================================================================================
//	CLASS BR_CSFPDialogInfo
//========================================================================================

//----------------------------------------------------------------------------------------
//	BR_CSFPDialogInfo::GetCallbackData
//
//  Return the callback data for any hook functions.  The default data is NULL since
//    there are no hook functions.
//----------------------------------------------------------------------------------------

inline void* BR_CSFPDialogInfo::GetCallbackData() const
{
	return (fCallbackData);
}


#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CSFPDialogInfo::WinGetFlags
//
//	Returns the flags for the Windows OpenFileDialog.  The default flags are set to
//    OFN_CREATEPROMPT | OFN_OVERWRITEPROMPT
//----------------------------------------------------------------------------------------

inline long BR_CSFPDialogInfo::WinGetFlags() const
{
	return (fWinDialogFlags);
}
#endif


#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CSFPDialogInfo::BedWinGetFlags
//
//  Return the number of Macintosh file types in the list (default maximum is 4).
//----------------------------------------------------------------------------------------

inline short BR_CSFPDialogInfo::BedMacGetNumberOfFileTypes() const
{
	return (fMacNumberOfTypes);
}
#endif




//========================================================================================
//	CLASS BR_XMacTooManyFileTypes
//========================================================================================

//----------------------------------------------------------------------------------------
//	BR_XMacTooManyFileTypes::GetNumberOfTypes
//
//  Returns the number of types that the user tried to store.
//----------------------------------------------------------------------------------------

inline unsigned long BR_XMacTooManyFileTypes::GetNumberOfTypes() const
{
	return (fNumberOfTypesRequested);
}


#endif
