#if !defined(BROBJECT_H) && !defined(__BEDRC__)
#define BROBJECT_H
//========================================================================================
//
//     File:			BRObject.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	August 15, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#ifndef   BRAUTODE_H
#include "BRAutoDe.h"
#endif

#ifndef   BRBEDEXC_H
#include "BRBedExc.h"
#endif

#ifndef BREXCLIB_H
#include "BRExcLib.h"
#endif

#ifndef   CASTDOWN_H
#include "castdown.h"
#endif

#include <stddef.h>

//========================================================================================
// CLASS BR_CObject
//========================================================================================

class BR_CObject : public _BR_CAutoDestructObject
{
public:
	typedef int Relation;
	enum RelationConstants { kLessThan = -1, kEqualTo = 0, kGreaterThan = 1 };
	
	virtual~ BR_CObject();

	// Protocol to support collections.
	
	BR_Boolean IsSame(const BR_CObject& Object) const;
	virtual BR_Boolean IsEqual(const BR_CObject& object) const;
	virtual Relation Compare(const BR_CObject& object) const;
	virtual unsigned long Hash() const;

	// Overloaded new and delete operators
	
	void* operator new(size_t size);
	void* operator new(size_t size,
					   void* block);
	void operator delete(void* block);

	// Runtime type checking methods
	
	static BR_CObject& CastDown(BR_CObject& p);
	static const BR_CObject& CastDown(const BR_CObject& p);
	static BR_CObject* CastDown(BR_CObject* p);
	static const BR_CObject* CastDown(const BR_CObject* p);
	virtual void* _CastDown(const char*) const;
	static const char* _GetClassName();
	virtual const char* ClassName() const;

protected:
	BR_CObject();
	
	void AssertSameClass(const BR_CObject& object) const;
};

//----------------------------------------------------------------------------------------
// BR_CObject::IsSame
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CObject::IsSame(const BR_CObject& object) const
{
	return this == &object;
}

//----------------------------------------------------------------------------------------
// BR_CObject::new
//----------------------------------------------------------------------------------------

inline void* BR_CObject::operator new(size_t size,
									  void* block)
{
	return (block != NULL) ? block : operator new(size);
}

//----------------------------------------------------------------------------------------
// BR_CObject::CastDown
//----------------------------------------------------------------------------------------

inline BR_CObject& BR_CObject::CastDown(BR_CObject& object)
{
	return object;
}

//----------------------------------------------------------------------------------------
// BR_CObject::CastDown
//----------------------------------------------------------------------------------------

inline const BR_CObject& BR_CObject::CastDown(const BR_CObject& object)
{
	return object;
}

//----------------------------------------------------------------------------------------
// BR_CObject::CastDown
//----------------------------------------------------------------------------------------

inline BR_CObject* BR_CObject::CastDown(BR_CObject* object)
{
	return object;
}

//----------------------------------------------------------------------------------------
// BR_CObject::CastDown
//----------------------------------------------------------------------------------------

inline const BR_CObject* BR_CObject::CastDown(const BR_CObject* object)
{
	return object;
}

#ifndef BR_DEBUG
//----------------------------------------------------------------------------------------
// BR_CObject::AssertSameClass
//----------------------------------------------------------------------------------------

inline void BR_CObject::AssertSameClass(const BR_CObject& /*object*/) const
{
}
#endif

#endif
