#if !defined(BRMODULE_H) && !defined(__BEDRC__)
#define BRMODULE_H
//========================================================================================
//
//     File:			BRModule.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	September 13, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRBUREAU_H
#include "BRBureau.h"
#endif

#ifndef BRFILESP_H
#include "BRFileSp.h"
#endif

#ifndef BRMSTRLI_H
#include "BRMStrLi.h"
#endif

//========================================================================================
// Macros for loading objects from resources
//========================================================================================

//----------------------------------------------------------------------------------------
// IsThisClass
//
// Attempts to create an object by class name, using the default constructor for the
// class.
//----------------------------------------------------------------------------------------

#define IsThisClass(testClassName, createClassName)		\
    if (BR_CCharString255(#testClassName) == createClassName)	\
    {													\
        return new testClassName;						\
    }

//----------------------------------------------------------------------------------------
// IsThisViewClass
//
// Attempts to create a view from resource.
//----------------------------------------------------------------------------------------

#define IsThisViewClass(ClassName, Res)									\
    if(Res.CheckClass(#ClassName))										\
    {																	\
        return new ClassName(((BR_CViewResource&)Res).GetEnclosure(),	\
                              ((BR_CViewResource&)Res).GetSupervisor(),	\
                              *Res.GetModule(),							\
                              *Res.GetResource());						\
    }

//----------------------------------------------------------------------------------------
// IsThisAdornerClass
//
// 	Attempts to create an adorner from resource. 
//	This is big but will be replace later by something better [HLX]
//----------------------------------------------------------------------------------------

#define IsThisAdornerClass(ClassName, Res)\
    if (Res.CheckClass(#ClassName))\
    {\
		BR_CAdorner *adorner = NULL;\
		if (((BR_SAdornerResource*)Res.GetResource())->fSharedAdorner)\
			adorner = BR_CAdorner::GetSharedAdorner("ClassName");\
		\
		if (adorner == NULL)\
			adorner =  new ClassName(*Res.GetModule(),	*Res.GetResource());\
		\
		BR_CView* pane = (BR_CView*)((BR_CViewResource&)Res).GetEnclosure(); \
		pane->AddAdorner(adorner, ((BR_SAdornerResource*)Res.GetResource())->fPriority);\
		return adorner;\
   }

//----------------------------------------------------------------------------------------
// IsThisMenuClass
//
// Used to load menus with the code which normally loads view resources. Here we of course
// cheat, but...
//----------------------------------------------------------------------------------------

#define IsThisMenuClass(ClassName, Res)										\
    if(Res.CheckClass(#ClassName))											\
    {																		\
        return new ClassName(*((BR_CMenuResource&)Res).GetApplication(),	\
                              *((BR_CMenuResource&)Res).GetParentMenu(),	\
                              *Res.GetModule(),								\
                              *Res.GetResource());							\
    }

//----------------------------------------------------------------------------------------
// IsThisObjectClass
//
// Attempts to create an object from resource using the same mechanism as views loaded
// from resource.
//----------------------------------------------------------------------------------------

#define IsThisObjectClass(ClassName, Res)				\
    if(Res.CheckClass(#ClassName))						\
    {													\
        return new ClassName(*Res.GetParentObject(),	\
                             *Res.GetModule(),			\
                             *Res.GetResource());		\
    }


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CBitmap;
class BR_CCursor;
class BR_CIcon;
class BR_CMenu;
class BR_CObjectResource;
class BR_CPicture;
class BR_CView;
struct BR_SResourceHeader;


//========================================================================================
// CLASS BR_CModule
//========================================================================================

class BR_CModule : public BR_CBureaucrat
{
public:
	virtual BR_Boolean LoadBitmap(BR_CBitmap& bitmap,
								  BR_ResourceId resourceId) const;
	BR_Boolean HasResourceBitmap(BR_ResourceId resourceId) const;

	virtual BR_Boolean LoadIcon(BR_CIcon& icon,
								BR_ResourceId resourceId) const;
	BR_Boolean HasResourceIcon(BR_ResourceId resourceId) const;

	virtual BR_Boolean LoadCursor(BR_CCursor& cursor,
								  BR_ResourceId resourceId) const;
	BR_Boolean HasResourceCursor(BR_ResourceId resourceId) const;

	virtual BR_Boolean LoadString(BR_CMultiStringList::StringId stringId,
								  BR_TString<BR_Char>& buffer) const;
	BR_Boolean HasResourceString() const;

	virtual BR_Boolean LoadString(BR_ResourceId resourceId,
								  BR_CMultiStringList::StringId stringId,
								  BR_TString<BR_Char>& buffer) const;
	BR_Boolean HasResourceMultiString(BR_ResourceId resourceId) const;

	virtual BR_Boolean LoadLong(BR_ResourceId resourceId,
								long fKeyValue,
								long& fDataValue) const;
	BR_Boolean HasResourceMultiLong(BR_ResourceId resourceId) const;

	virtual BR_CMenu* LoadMenu(BR_CApplication* application,
							   const BR_CModule* resourceModule,
							   BR_ResourceId resourceId) const;
	BR_Boolean HasResourceMenu(BR_ResourceId resourceId) const;

	virtual BR_CObject* LoadView(BR_CView* enclosure,
								 BR_CBureaucrat* supervisor,
								 const BR_CModule* resourceModule,
								 BR_ResourceId resourceId) const;

	BR_Boolean HasResource(BR_ResourceId resourceId,
						   BR_ResourceType resourceType) const;

	virtual BR_CObject* CreateObjectFromResource(BR_CObjectResource& objectResource,
												 BR_Boolean callSupervisor = TRUE) const;

	virtual BR_CObject* CreateObjectByName(const BR_TString<BR_Char>& className,
										   BR_Boolean callSupervisor = TRUE) const;

	void GetFileSpec(BR_CFileSpecification& moduleFileSpec) const;

	BR_PlatformHandle LoadResource(BR_ResourceId resourceId,
								   BR_ResourceType resourceType,
								   unsigned long& resourceSize) const;// ?INTERNAL?
	BR_PlatformHandle GetHandle() const;		// ?INTERNAL?

protected:
	BR_CModule(BR_CModule* supervisor,
			   BR_PlatformHandle hInst);
	virtual~ BR_CModule();
	void SetHandle(BR_PlatformHandle newHandle);// ?INTERNAL?

private:
	void ThrowExceptionIfResourceLoadError(BR_PlatformHandle resourceHandle,
										   BR_ResourceId resourceId,
										   BR_ResourceType resourceType) const;

	BR_PlatformHandle fInstanceHandle;


#ifdef BR_BUILD_MAC
public:
	virtual BR_Boolean LoadPicture(BR_CPicture& picture,
								   BR_ResourceId resourceId) const;
	BR_Boolean HasResourcePicture(BR_ResourceId resourceId) const;

protected:
	void SetFileSpec(const BR_CFileSpecification& newFileSpec);// ?INTERNAL?

private:
	BR_CFileSpecification* fFileSpec;
#endif


#ifdef BR_BUILD_WIN
public:
	virtual void RunApplication(BR_ResourceId applicationNameId);
	BR_PlatformHandle WinLoadAccelerators(BR_ResourceId resourceId) const;// ?INTERNAL?
	BR_Boolean WinHasResourceAccelerators(BR_ResourceId resourceId) const;// ?INTERNAL?
#endif

	BR_SETCLASSNAME(BR_CModule);
};


//----------------------------------------------------------------------------------------
// BR_CModule::GetHandle
//----------------------------------------------------------------------------------------

inline BR_PlatformHandle BR_CModule::GetHandle() const
{
	return fInstanceHandle;
}

//----------------------------------------------------------------------------------------
// BR_CModule::SetHandle
//----------------------------------------------------------------------------------------

inline void BR_CModule::SetHandle(BR_PlatformHandle newHandle)
{
	fInstanceHandle = newHandle;
}


#endif
