#if !defined(BRMHVIEW_H) && !defined(__BEDRC__)
#define BRMHVIEW_H
//========================================================================================
//
//     File:			BRMHView.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	3/15/93
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifdef BR_BUILD_MAC

#ifndef BRHVIEW_H
#include "BRHView.h"
#endif

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef __WINDOWS__
#include <Windows.h>
#endif

#ifndef __QUICKDRAW__
#include <Quickdraw.h>
#endif

#ifndef __EVENTS__
#include <Events.h>
#endif

//========================================================================================
// Forward
//========================================================================================

class BR_CWindow;

//========================================================================================
// class BR_CMacWindowHelper
//========================================================================================

class BR_CMacWindowHelper : public BR_CViewHelper
{
public:
	BR_CMacWindowHelper(BR_CWindow *theWindow,
						BR_CView::ViewStyle windowStyle, 
						const BR_CRectangle& windowFrame);
	virtual ~BR_CMacWindowHelper();
	
	// ----- Frame
	virtual void 	SetFrame(const BR_CRectangle& newFrame, BR_Boolean redraw);
	virtual void	SetViewFrame(BR_Boolean redraw);
	
	// ----- Border size
	virtual void	GetBorderSize(BR_CRectangle& borderSize) const;
	BR_Boolean 		BuildWindowRegions(BR_Boolean build) const;

	// ----- Enclosure
	virtual void	SetEnclosure(BR_CView *enclosure);
	
	// ----- Drag/Grow/Zoom
	void 			DoDrag(EventRecord &macEvent);
	void 			DoGrow(EventRecord &macEvent);
	void 			DoZoom(short whichPart);
	
	// ----- Show/Hide
	virtual void 	Show(BR_Boolean show = TRUE);
	virtual void	BedShowHideSubviews(BR_Boolean state);

	// ----- Activate
	void 			DoActivate(BR_Boolean activate);

	// ----- Window Title
	virtual void				SetTitle(const BR_TString<BR_Char>& text);
	virtual unsigned long 	GetTitle(BR_TString<BR_Char>& text) const;
	virtual unsigned long 	GetTitleLength() const;

	// ----- Update/Refresh
	virtual void	Update();
	virtual void	RefreshRect(const BR_CRectangle &refreshRect);
	virtual void	UnRefreshRect(const BR_CRectangle &refreshRect);

	// ----- Focus
	virtual void	SetFocus();
	virtual void	SetEnable(BR_Boolean state);

	// ----- Capture
	void		SetCapture();
	void		ReleaseCapture();
	
	// ----- Auto Redraw
	void			SetAutoRedraw(BR_Boolean autoRedraw);
	
	// ----- for zooming
	void 			GetStandardStateFrame(const BR_CRectangle &boundingRect,
											BR_CRectangle &stdFrame) const;
	void 			GetUserStateFrame(const BR_CRectangle &boundingRect,
											BR_CRectangle &userFrame) const;
	GDHandle 		GetMaxIntersectedDevice(BR_CRectangle &screenRect) const;

	// ----- Draw the grow icon
	void 			DrawGrowIcon();
	
	// ----- Defer Move
	virtual void 		BeginDeferMove();
	virtual void 		EndDeferMove();
	
	// ----- Conversion
	virtual void		LocalToGlobal(BR_CPoint &pt) const;
	virtual void		GlobalToLocal(BR_CPoint &pt) const;

	// ----- Getters/Setters
	BR_CWindow		*GetWindow() const;

	// ----- Window Manager to Bedrock
	static BR_CMacWindowHelper *WMgrToWindowHelper(WindowPtr aWMgrWindow);
	static BR_CWindow 			*WMgrToWindow(WindowPtr aWMgrWindow);

	BR_Boolean IsInUpdate() const;

protected:
	unsigned short WindowStyleToProcId(BR_CView::ViewStyle windowStyle);

private:
	BR_CWindow			*fWindow;			// same as BR_CViewHelper::fView to avoid type cast
	unsigned short 	fProcId;			// window defintion ID of the window
	BR_Boolean			fInUpdate;
	
	BR_SETCLASSNAME(BR_CMacWindowHelper);
};


//----------------------------------------------------------------------------------------
//	BR_CMacWindowHelper::GetWindow
//----------------------------------------------------------------------------------------

inline BR_CWindow *BR_CMacWindowHelper::GetWindow() const
{
	return fWindow;
}

//------------------------------------------------------------------------
// BR_CMacWindowHelper::IsActive
//------------------------------------------------------------------------

inline BR_Boolean BR_CMacWindowHelper::IsInUpdate() const
{
	return fInUpdate;
}

#endif

#endif