#if !defined(BRMESTRM_H) && !defined(__BEDRC__)
#define BRMESTRM_H
//========================================================================================
//
//     File:		BRMeStrm.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 22, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRSTREAM_H
#include "BRStream.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

//========================================================================================
//	CLASS BR_CMemStream
//========================================================================================

class BR_CMemStream : public BR_CStream
{
public:
	enum HandleOwner
	{
		kStreamIsOwner,							// dtor unlocks and frees handle
		kStreamIsNotOwner						// dtor neither unlocks nor frees handle
	};


	BR_CMemStream(StreamSize initialSize,
				  BR_Boolean canGrow);
	virtual~ BR_CMemStream();

	virtual BR_Boolean Read(void* destination,
							BR_CStream::StreamBufferSize& readBytes);

	virtual BR_Boolean Write(void* source,
							 BR_CStream::StreamBufferSize& writeBytes);

	virtual BR_Char* GetPointer(StreamIndex offset);
	virtual void ReleasePointer();

	virtual BR_Boolean Move(StreamIndex destinationoffset,
							StreamIndex sourceoffset,
							StreamBufferSize moveBytes);

	void SetHandle(BR_PlatformHandle theHandle,
				   HandleOwner handleOwner = kStreamIsOwner);
				   
	operator BR_PlatformHandle();

protected:
	virtual BR_Boolean SetMemSize(StreamSize newSize);
	virtual StreamSize GetMemSize() const;	// Gets the size of the fMem block

private:
	void FreeStreamOwnedMemory();
	unsigned long AdjustMemSize(StreamSize newSize) const;

	char* fMemoryPtr;							// Pointer to fMemory associated with stream.
	BR_PlatformHandle fHandle;					// If non-NULL, fMemory associated with handle.
	HandleOwner fHandleOwner;					// Owner of 'fHandle'.
	StreamSize fStreamSize;							// Number of allocated bytes.
	BR_Boolean fAllowGrow;						// If TRUE, SetLength() may be called to change
	//		the size of the fMemory buffer.

	BR_SETCLASSNAME(BR_CMemStream);
};

//========================================================================================
// CLASS BR_CAcquireMemStreamPointer - Resource acquistion helper to acquire a stream's pointer.
//========================================================================================

class BR_CAcquireMemStreamPointer : public _BR_CAutoDestructObject
{
public:
	BR_CAcquireMemStreamPointer(BR_CMemStream* aMemStream,
								const BR_CStream::StreamIndex offset);
	virtual~ BR_CAcquireMemStreamPointer();
	char* const GetPointer() const;
	
private:
	BR_CMemStream* fMemStream;
	char* const fMemPointer;
};

//----------------------------------------------------------------------------------------
// BR_CAcquireMemStreamPointer::~BR_CAcquireMemStreamPointer
//----------------------------------------------------------------------------------------

inline char *const  BR_CAcquireMemStreamPointer::GetPointer() const
{
	return fMemPointer;
}

#endif
