#if !defined(BRMACUTI_H) && !defined(__BEDRC__)
#define BRMACUTI_H
//========================================================================================
//
//     File:			BRMacUti.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	February 27, 1992
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifdef BR_BUILD_MAC

#ifndef __QUICKDRAW__
#include <QuickDraw.h>
#endif

#ifndef   BRSTDDEF_H
#include "BRStdDef.h"
#endif

#ifndef BREXCLIB_H
#include "BRExcLib.h"
#endif


//========================================================================================
// Forward declarations
//========================================================================================

struct GrafPort;

//========================================================================================
//	Class BR_CBedMacLocalPort
//
// BR_CBedMacLocalPort preserves the current port and origin in its constructor and
// restores it in its destructor. When used as a stack-based object, it's a convenient way
// to do the usual GrafPort save and restore routine.
//========================================================================================

class BR_CBedMacLocalPort : public _BR_CAutoDestructObject
{
public:
	BR_CBedMacLocalPort(GrafPort* localPort);
	~BR_CBedMacLocalPort();

private:
	GrafPort* fSavedPort;
	short fSavedXOrigin;
	short fSavedYOrigin;
};


//========================================================================================
// Global procedure declarations
//========================================================================================

BR_Boolean BR_BedMacIsColorPort(GrafPort* fMacPort);

void BR_BedMacComputeArcPoint(Rect* arcRect,
							  Point& arcPoint,
							  short angle,
							  short qdPenWidth,
							  short qdPenHeight);

void BR_BedMacArcPoints(Point& startPoint,
						Point& arcPoint,
						Point& centerPoint,
						Rect* arcRect,
						short start,
						short arc,
						short qdPenWidth,
						short qdPenHeight);

#endif

#endif
