#if !defined(BRHELP_H) && !defined(__BEDRC__)
#define BRHELP_H
//========================================================================================
//
//     File:		BRHelp.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	18 Nov 1991
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRCURSOR_H
#include "BRCursor.h"
#endif

#ifndef BRMENU_H
#include "BRMenu.h"
#endif

#ifndef BRMSTRLI_H
#include "BRMStrLi.h"
#endif

#ifndef BRSTRIDS_H
#include "BRStrIds.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CView;
class BR_CFileSpecification;


//========================================================================================
// CLASS BR_CHelp
//========================================================================================

class BR_CHelp : public BR_CObject
{
public:
	typedef long int HelpTopic;
	enum HelpTopicConstants						// NOTE: All help ids below kUser are fReserved by bcl
	{
		kUser = 1, kNone = 0, kIndex = -1, kQuit = -2, kHelp = -3
	};


	BR_CHelp(const BR_CApplication& theApplication,
			 BR_CMultiStringList::StringId helpFileStringTableId = IDS_HELPFILE);
	~BR_CHelp();

	BR_CCursor* GetHelpCursor() const;
	BR_Boolean GetHelpMode() const;

	void SetHelpMode(BR_Boolean mode);

	virtual BR_Boolean ShowHelp(HelpTopic helpId);

	void MenuItemHighlighted(BR_CView* theView,
							 BR_CMenu::ItemPosition itemId);// ??Internal??
	void HelpKeyPressedInMenu();				// ??Internal??

private:
	BR_Boolean fHelpFileValid;					// TRUE implies have help file spec.
	BR_Boolean fHelpMode;						// TRUE implies in help mode.
	BR_CCursor fHelpCursor;						// Help cursor.
	BR_CMenu::ItemPosition fActiveMenuItem;		// Active menu item.
	BR_CView* fActiveMenusView;					// View associated with active menu item.
	BR_CFileSpecification* fFileSpec;			// The file associated with this help object.

	BR_Boolean SetFileSpec(const BR_CApplication& theApplication,
								 BR_CMultiStringList::StringId helpFileStringTableId);

#ifdef BR_BUILD_WIN
private:
	HWND fApplicationDesktopWindow;				// Handle to desktop window.
#endif

	BR_SETCLASSNAME(BR_CHelp);

};


//----------------------------------------------------------------------------------------
// BR_CHelp::SetHelpMode
//----------------------------------------------------------------------------------------

inline void BR_CHelp::SetHelpMode(BR_Boolean mode)
{
	fHelpMode = mode;
}

//----------------------------------------------------------------------------------------
// BR_CHelp::GetHelpMode
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CHelp::GetHelpMode() const
{
	return fHelpMode;
}

//----------------------------------------------------------------------------------------
// BR_CHelp::GetHelpCursor
//----------------------------------------------------------------------------------------

inline BR_CCursor * BR_CHelp::GetHelpCursor() const
{
	return (BR_CCursor *)&fHelpCursor;
}
#endif
