#if !defined(BRGRVLA_H) && !defined(__BEDRC__)
#define BRGRVLA_H
//========================================================================================
//
//     File:			BRGrVLa.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/24/92
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRGRCOMM_H
#include "BRGrComm.h"
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif

#ifndef BRPEN_H
#include "BRPen.h"
#endif

#if defined(BR_BUILD_WIN) && !defined(__INC_WINDOWS)
#include <windows.h>
#endif

//========================================================================================
// Forward class declaration
//========================================================================================

class BR_CGraphicsTool;

//========================================================================================
// Generic code
//========================================================================================

//========================================================================================
// CLASS BR_CBedWallPaper
//
// Encapsulates a platform wallpaper/brush.
//========================================================================================

class BR_CBedWallPaper : public _BR_CAutoDestructObject
{
public:
	BR_CBedWallPaper();
	~BR_CBedWallPaper();

	// call Create() after you use either of these two methods
	BR_CBedWallPaper(const BR_CBedWallPaper& bedWallPaper);
	BR_CBedWallPaper& operator=(const BR_CBedWallPaper& bedWallPaper);

	void SetPattern(BR_Pattern pattern);
	void SetHatchColor(const BR_CColor& hatchColor);
	void SetFillColor(const BR_CColor& fillColor);

	BR_Pattern GetPattern() const;
	BR_CColor GetHatchColor() const;
	BR_CColor GetFillColor() const;

	void Create(BR_CGraphicsTool* client);
	void Dispose();

	short GetPlatformPatternId() const;

private:
	BR_Pattern fPattern;
	BR_CColor fHatchColor;
	BR_CColor fFillColor;

	//----------------------------------------------------------------------------------------
	// Macintosh 
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	PixPatHandle MacGetPixPat() const;
	PatPtr MacGetPattern() const;

	void MacPrepareOp() const;

private:
	Pattern fMacPattern;						// b&w fill pattern
	PixPatHandle fMacPixPat;					// color pixpat
#endif

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	HANDLE WinGetHandle() const;
	BR_Boolean WinIsStock() const;

#define RGB_DONTCARE	0xFF000000

	void WinGetColors(BR_CColor::RGBValue& textColor,
									BR_CColor::RGBValue& backgroundColor) const;

private:
	HANDLE fBrush;
	BR_Boolean fIsStock:1;

	void WinSetHandleToZero();
	void WinSetGDIHandle(HANDLE brush,
						 BR_CGraphicsTool* client);
	void WinSetStockHandle(unsigned short index,
						   BR_CGraphicsTool* client);
	void WinCreateSolidBrush(const BR_CColor& color,
							 BR_CGraphicsTool* client);
#endif

};

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::SetPattern
//----------------------------------------------------------------------------------------
inline void BR_CBedWallPaper::SetPattern(BR_Pattern pattern)
{
	fPattern = pattern;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::SetHatchColor
//----------------------------------------------------------------------------------------
inline void BR_CBedWallPaper::SetHatchColor(const BR_CColor& hatchColor)
{
	fHatchColor = hatchColor;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::SetFillColor
//----------------------------------------------------------------------------------------
inline void BR_CBedWallPaper::SetFillColor(const BR_CColor& fillColor)
{
	fFillColor = fillColor;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::GetPattern
//----------------------------------------------------------------------------------------
inline BR_Pattern BR_CBedWallPaper::GetPattern() const
{
	return fPattern;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::GetHatchColor
//----------------------------------------------------------------------------------------
inline BR_CColor BR_CBedWallPaper::GetHatchColor() const
{
	return fHatchColor;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::GetFillColor
//----------------------------------------------------------------------------------------
inline BR_CColor BR_CBedWallPaper::GetFillColor() const
{
	return fFillColor;
}

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::WinSetHandleToZero
//----------------------------------------------------------------------------------------
inline void BR_CBedWallPaper::WinSetHandleToZero()
{
	fBrush = 0;
	fIsStock = TRUE;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::WinGetHandle
//----------------------------------------------------------------------------------------
inline HANDLE BR_CBedWallPaper::WinGetHandle() const
{
	return fBrush;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::WinIsStock
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CBedWallPaper::WinIsStock() const
{
	return fIsStock;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::MacGetPixPat
//----------------------------------------------------------------------------------------
inline PixPatHandle BR_CBedWallPaper::MacGetPixPat() const
{
	return fMacPixPat;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::MacGetPattern
//----------------------------------------------------------------------------------------
inline PatPtr BR_CBedWallPaper::MacGetPattern() const
{
	return (PatPtr)&fMacPattern;
}
#endif

//========================================================================================
// CLASS BR_CBedPen
//
// Similar to BR_CBedWallPaper: used to encapsulate plaform-specific pen.
//========================================================================================

class BR_CBedPen : public _BR_CAutoDestructObject
{
public:
	BR_CBedPen();
	~BR_CBedPen();

	// call Create() after you use either of these two methods
	BR_CBedPen(const BR_CBedPen& bedPen);
	BR_CBedPen& operator=(const BR_CBedPen& bedPen);

	void SetStyle(BR_CPen::PenStyle penStyle);
	void SetDashColor(const BR_CColor& dashColor);
	void SetGapColor(const BR_CColor& gapColor);

	BR_CPen::PenStyle GetStyle() const;
	BR_CColor GetDashColor() const;
	BR_CColor GetGapColor() const;

	void Create(BR_CGraphicsTool* client);
	void Dispose();

private:
	BR_CPen::PenStyle fPenStyle;
	BR_CColor fDashColor;
	BR_CColor fGapColor;

	//--------------------------------------------------------------------------------
	// Macintosh
	//--------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	void MacPrepareOp() const;
#endif

};

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::SetStyle
//----------------------------------------------------------------------------------------
inline void BR_CBedPen::SetStyle(BR_CPen::PenStyle penStyle)
{
	fPenStyle = penStyle;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::SetDashColor
//----------------------------------------------------------------------------------------
inline void BR_CBedPen::SetDashColor(const BR_CColor& dashColor)
{
	fDashColor = dashColor;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::SetGapColor
//----------------------------------------------------------------------------------------
inline void BR_CBedPen::SetGapColor(const BR_CColor& gapColor)
{
	fGapColor = gapColor;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::GetStyle
//----------------------------------------------------------------------------------------
inline BR_CPen::PenStyle BR_CBedPen::GetStyle() const
{
	return fPenStyle;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::GetDashColor
//----------------------------------------------------------------------------------------
inline BR_CColor BR_CBedPen::GetDashColor() const
{
	return fDashColor;
}

//----------------------------------------------------------------------------------------
// BR_CBedWallPaper::GetGapColor
//----------------------------------------------------------------------------------------
inline BR_CColor BR_CBedPen::GetGapColor() const
{
	return fGapColor;
}


#if 0

//========================================================================================
// CLASS BR_CBedDrawContext
// Encapsulates a DC (with lazy attribute selection) or a graf port
//========================================================================================

class BR_CBedDrawContext
{
public:
	BR_CBedDrawContext();

protected:

private:

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	operator HDC() const;
	void WinSetDC(HDC hdc);

private:
	HDC fHDC;
#endif

	//----------------------------------------------------------------------------------------
	// Macintosh
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	operator GrafPtr(void) const;
	void MacSetGrafPtr(GrafPtr grafPtr);

private:
	GrafPtr fGrafPtr;
#endif

};

#endif

#endif


