#if !defined(BRGROUP_H) && !defined(__BEDRC__)
#define BRGROUP_H
//========================================================================================
//
//     File:			BRGroup.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	May 8, 1992
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include "BRView.h"		// always include the base class
#endif

#ifndef BRRADIOB_H
#include "BRRadioB.h"	// and classes whose hierarchy we need
#endif

//========================================================================================
//	STRUCT BR_SControlGroupRes
//========================================================================================

struct BR_SControlGroupRes : BR_SViewResource
{
    char   					fTitle[64];
};

//========================================================================================
//	CLASS BR_CControlGroup
//	This class manages a group of controls
//========================================================================================

class BR_CControlGroup : public BR_CView
{
public:
	BR_CControlGroup(BR_CView* enclosure,
			 		BR_CBureaucrat* supervisor,
			 		BR_Distance width,
			 		BR_Distance height,
			 		BR_Coordinate x,
			 		BR_Coordinate y,
			 		ViewSizing horizontalSizing,
			 		ViewSizing verticalSizing,
					ViewId	viewId,
					const BR_TString<BR_Char> &caption);
	BR_CControlGroup(BR_CView* enclosure,
					 BR_CBureaucrat* supervisor,
					 const BR_CModule& module,
					 BR_SResource& resource);

	virtual					~BR_CControlGroup();

	BR_CControl* 				GetActiveControl() const;

	void 						SetActiveControl(BR_CControl* control);

	// Inherited methods
	BR_Boolean 					SetFocus();
	virtual BR_CColor 			GetBackgroundColor() const;
	
protected:
	
	void						InitControlGroup(const BR_CRectangle &frame, const BR_TString<BR_Char> &caption);
	
private:
	BR_CControl					*fActiveControl;
	
	BR_SETCLASSNAME(BR_CControlGroup);
};

//----------------------------------------------------------------------------------------
//	BR_CControlGroup::GetActiveControl
//----------------------------------------------------------------------------------------
inline BR_CControl* BR_CControlGroup::GetActiveControl() const
{
	return fActiveControl;
}

//----------------------------------------------------------------------------------------
//	BR_CControlGroup::SetActiveControl
//----------------------------------------------------------------------------------------
inline void BR_CControlGroup::SetActiveControl(BR_CControl* control)
{
	fActiveControl = control;
}

//========================================================================================
//	CLASS BR_CControlGroup
//
//	This class provides management methods for a group of radio buttons
//========================================================================================

class BR_CRadioGroup : public BR_CControlGroup
{
public:
	BR_CRadioGroup(BR_CView* enclosure,
			 		BR_CBureaucrat* supervisor,
			 		BR_Distance width,
			 		BR_Distance height,
			 		BR_Coordinate x,
			 		BR_Coordinate y,
			 		ViewSizing horizontalSizing,
			 		ViewSizing verticalSizing,
					ViewId	viewId,
					const BR_TString<BR_Char> &caption);
	BR_CRadioGroup(BR_CView* enclosure,
				   BR_CBureaucrat* supervisor,
				   const BR_CModule& module,
				   BR_SResource& resource);

	virtual~ BR_CRadioGroup();

	// Access methods
	BR_CRadioButton* GetStation() const;
	BR_CRadioButton* GetFirstButton() const;

	// New virtual methods
	virtual void ChangeStation(BR_CRadioButton* button);
	virtual void ChangeStation(ViewId buttonId);
	virtual void AddButton(BR_CRadioButton* button);
	virtual void RemoveButton(BR_CRadioButton& button);

	virtual void SetNextStation();
	virtual void SetPreviousStation();

	// Inherited virtual methods
	virtual BR_Boolean DoKeyDown(Key key,
								 unsigned short repeatCount,
								 BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean SetFocus();
	virtual BR_Boolean SetNextSubview(BR_Boolean& relinquishFocusFailed,
									  BR_Boolean topLevel = FALSE);
	virtual BR_Boolean SetPreviousSubview(BR_Boolean& relinquishFocusFailed,
										  BR_Boolean topLevel = FALSE);
	virtual BR_Boolean SetFirstSubview(BR_Boolean topLevel = FALSE);
	virtual BR_Boolean SetLastSubview(BR_Boolean topLevel = FALSE);

protected:
	void SetStation(BR_CRadioButton* button);

private:
	void InitRadioGroup();						// bug 1500

	BR_SETCLASSNAME(BR_CRadioGroup);
};

//----------------------------------------------------------------------------------------
//	BR_CRadioGroup::GetStation
//----------------------------------------------------------------------------------------
inline BR_CRadioButton* BR_CRadioGroup::GetStation() const
{
	return CASTDOWN(BR_CRadioButton, (BR_CObject*)GetActiveControl());
}

//----------------------------------------------------------------------------------------
//	BR_CRadioGroup::GetFirstButton
//----------------------------------------------------------------------------------------
inline BR_CRadioButton* BR_CRadioGroup::GetFirstButton() const
{
	return CASTDOWN(BR_CRadioButton, (BR_CObject*)GetFirstSubview());
}

//----------------------------------------------------------------------------------------
//	BR_CRadioGroup::SetStation
//----------------------------------------------------------------------------------------
inline void BR_CRadioGroup::SetStation(BR_CRadioButton* button)
{
	SetActiveControl(button);
}

#endif


