#if !defined(BRGRCOMM_H) && !defined(__BEDRC__)
#define BRGRCOMM_H
//========================================================================================
//
//     File:			BRGrComm.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/4/92
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#if defined(BR_BUILD_WIN) && !defined(_INC_WINDOWS)
#include <windows.h>
#endif

#if defined(BR_BUILD_MAC) && !defined(BRMACWIN_H)
#include "BRMacWin.h"
#endif

#ifndef BRGRCOMM_K
#include "BRGrComm.k"
#endif

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__QUICKDRAW__)
#include <QuickDraw.h>
#endif

//----------------------------------------------------------------------------------------
// Draw modes and rop codes
//----------------------------------------------------------------------------------------

typedef short	BR_DrawMode;
typedef unsigned long BR_RasterOperation;

// These are various drawing modes.  The following notation is used to
// describe them:
//    P - The current pen
//    D - The destination bitmap
//    &, |, ^, and ~ have their usual C meanings (AND, OR, XOR, NOT)
//    0 - Zero
//    1 - One
// The equations by each drawing mode describe what bit value the
// destination bitmap receives, in terms of the destination bitmap and
// current pen.  For example, ~P & ~D means combine the inverse of the
// pen and bitmap, AND the result together, and put the result in the
// bitmap

#ifdef BR_BUILD_WIN
const BR_DrawMode BEDDM_COPYPEN     = R2_COPYPEN;       // P
const BR_DrawMode BEDDM_NOTCOPYPEN  = R2_NOTCOPYPEN;    // ~P
const BR_DrawMode BEDDM_MASKPEN     = R2_MASKPEN;       // (P & D)
const BR_DrawMode BEDDM_MASKNOTPEN  = R2_MASKNOTPEN;    // ~P & D
const BR_DrawMode BEDDM_XORPEN      = R2_XORPEN;        // P ^ D
const BR_DrawMode BEDDM_NOTXORPEN   = R2_NOTXORPEN;     // ~(P ^ D)
const BR_DrawMode BEDDM_MERGEPEN    = R2_MERGEPEN;      // P | D
const BR_DrawMode BEDDM_MERGENOTPEN = R2_MERGENOTPEN;   // ~P | D
const BR_DrawMode BEDDM_NOP         = R2_NOP;           // D

// Windows Specific draw Modes
const BR_DrawMode BEDDM_BLACK       = R2_BLACK;         // 0
const BR_DrawMode BEDDM_WHITE       = R2_WHITE;         // 1
const BR_DrawMode BEDDM_NOT         = R2_NOT;           // ~D
const BR_DrawMode BEDDM_NOTMERGEPEN = R2_NOTMERGEPEN;   // ~(P | D)
const BR_DrawMode BEDDM_MERGEPENNOT = R2_MERGEPENNOT;   // P | ~D
const BR_DrawMode BEDDM_NOTMASKPEN  = R2_NOTMASKPEN;    // ~(P & D)
const BR_DrawMode BEDDM_MASKPENNOT  = R2_MASKPENNOT;    // P & ~D
#endif

#ifdef BR_BUILD_MAC
const BR_DrawMode BEDDM_COPYPEN     = patCopy;          // P
const BR_DrawMode BEDDM_NOTCOPYPEN  = notPatCopy;       // ~P
const BR_DrawMode BEDDM_MASKPEN     = patOr;       	    // (P & D)
const BR_DrawMode BEDDM_MASKNOTPEN  = notPatOr;         // ~P & D
const BR_DrawMode BEDDM_XORPEN      = patXor;       	// P ^ D
const BR_DrawMode BEDDM_NOTXORPEN   = notPatXor;        // ~(P ^ D)
const BR_DrawMode BEDDM_MERGEPEN    = patBic;       	// P | D
const BR_DrawMode BEDDM_MERGENOTPEN = notPatBic;        // ~P | D
const BR_DrawMode BEDDM_NOP         = 0xFF02;           // D

// Unsupported Windows Specific Draw Modes
const BR_DrawMode BEDDM_BLACK       = -1;          		// 0
const BR_DrawMode BEDDM_WHITE       = -1;           	// 1
const BR_DrawMode BEDDM_NOT         = -1;           	// ~D
const BR_DrawMode BEDDM_NOTMERGEPEN = -1;               // ~(P | D)
const BR_DrawMode BEDDM_MERGEPENNOT = -1;         		// P | ~D
const BR_DrawMode BEDDM_NOTMASKPEN  = -1;               // ~(P & D)
const BR_DrawMode BEDDM_MASKPENNOT  = -1;               // P & ~D
#endif

// The are the various raster operations.  Their descriptions are similar
// to the descriptions for the drawing modes above, except that there are
// three sources combined:
//    D - The destination bitmap
//    S - The source bitmap
//    P - The selection brush (pattern)

#ifdef BR_BUILD_WIN
const BR_RasterOperation BEDROP_SRCCOPY             = SRCCOPY;          // S
const BR_RasterOperation BEDROP_SRCPAINT            = SRCPAINT;         // D | S
const BR_RasterOperation BEDROP_SRCAND              = SRCAND;           // D & S
const BR_RasterOperation BEDROP_SRCINVERT           = SRCINVERT;        // D ^ S
const BR_RasterOperation BEDROP_SRCERASE            = SRCERASE;         // S & ~D
const BR_RasterOperation BEDROP_NOTSRCCOPY          = NOTSRCCOPY;       // ~S
const BR_RasterOperation BEDROP_NOTSRCERASE         = NOTSRCERASE;      // ~(D | S)
const BR_RasterOperation BEDROP_MERGECOPY           = MERGECOPY;        // S & P
const BR_RasterOperation BEDROP_MERGEPAINT          = MERGEPAINT;       // ~S | D
const BR_RasterOperation BEDROP_PATCOPY             = PATCOPY;          // P
const BR_RasterOperation BEDROP_PATPAINT            = PATPAINT;         // ~S | P | D
const BR_RasterOperation BEDROP_PATINVERT           = PATINVERT;        // D ^ P
const BR_RasterOperation BEDROP_DSTINVERT           = DSTINVERT;        // ~D
const BR_RasterOperation BEDROP_BLACKNESS           = BLACKNESS;        // 0
const BR_RasterOperation BEDROP_WHITENESS           = WHITENESS;        // 1
#endif

#ifdef BR_BUILD_MAC
const BR_RasterOperation BEDROP_SRCCOPY             = srcCopy;          // S
const BR_RasterOperation BEDROP_SRCPAINT            = srcOr;            // D | S
const BR_RasterOperation BEDROP_SRCAND              = SRCAND;           // D & S
const BR_RasterOperation BEDROP_SRCINVERT           = srcXor;           // D ^ S
const BR_RasterOperation BEDROP_SRCERASE            = srcBic;           // S & ~D
const BR_RasterOperation BEDROP_NOTSRCCOPY          = notSrcCopy;       // ~S
const BR_RasterOperation BEDROP_NOTSRCERASE         = notSrcOr;         // ~(D | S)
const BR_RasterOperation BEDROP_MERGECOPY           = 0xffffffff;       // S & P
const BR_RasterOperation BEDROP_MERGEPAINT          = notSrcBic;        // ~S | D
const BR_RasterOperation BEDROP_PATCOPY             = 0xffffffff;       // P
const BR_RasterOperation BEDROP_PATPAINT            = 0xffffffff;       // ~S | P | D
const BR_RasterOperation BEDROP_PATINVERT           = 0xffffffff;       // D ^ P
const BR_RasterOperation BEDROP_DSTINVERT           = 0xffffffff;       // ~D
const BR_RasterOperation BEDROP_BLACKNESS           = 0xffffffff;       // 0
const BR_RasterOperation BEDROP_WHITENESS           = 0xffffffff;       // 1
#endif


//----------------------------------------------------------------------------------------
// Text Draw fFlags for use with DrawText(BR_CRectangle&,...)
//----------------------------------------------------------------------------------------

typedef unsigned short BR_DrawTextFlags;        // DrawText(cRect&...) fFlags

enum IndexFromPtOption
{
	kIndexFromPtCompleteFit,
	kIndexFromPtTextSelect
};

//----------------------------------------------------------------------------------------
// BR_CFont - related stuff
//----------------------------------------------------------------------------------------

// Structure that is used to return font metrics, returned in pane logical units

struct BR_TextMetrics
{
	unsigned short nAscent;							// Height above the baseline
	unsigned short nDescent;							// Height below the baseline
	unsigned short nLeading;							// Extra fSpace below the baseline
	unsigned short fMaxCharWidth;						// Maximum character width
};

//----------------------------------------------------------------------------------------
// WallPaper - related stuff
//----------------------------------------------------------------------------------------

typedef unsigned short BR_Pattern;			// Pattern type; same pattern can be used with pens


//----------------------------------------------------------------------------------------
// BR_CGraphicsTool-related stuff
// Not nested in BR_CGraphicsTool to avoid having to include <BRGraphT.h> into
// every .h file that needs these types
//----------------------------------------------------------------------------------------

struct BR_SGraphicsToolSuspendResumeState
{
#ifdef BR_BUILD_WIN
	HANDLE fHandle;
#endif
};

enum GraphicsToolSelectionOptions
{
	kToolSuspendResume,
	kToolSelectUnselect
};

#endif
