#if !defined(BRFONT_H) && !defined(__BEDRC__)
#define BRFONT_H
//========================================================================================
//
//     File:			BRFont.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/24/90
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRFONT_K
#include "BRFont.k"
#endif

#ifndef BRGRAPHT_H
#include "BRGraphT.h"
#endif

#ifndef BRCHRSTR_H
#include "BRChrStr.h"
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif

#ifndef BRGRCOMM_H
#include "BRGrComm.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__QUICKDRAW__)
#include <QuickDraw.h>
#endif

//========================================================================================
//	Forward class declaration
//========================================================================================

class BR_CModule;

//========================================================================================
//	class BR_CFont
//========================================================================================

class BR_CFont : public BR_CGraphicsTool
{
	friend BR_CGraphicsToolSelector;
	friend BR_CCanvas;

public:
	typedef unsigned short int FontStyle;
	typedef unsigned short int FontSize;
	typedef unsigned short int FontId;
		
public:
	BR_CFont(const BR_TString<BR_Char>& faceName,
			 FontSize height,
			 FontStyle fStyle);

	BR_CFont(FontId faceNameId,
			 FontSize height,
			 FontStyle fStyle);

	BR_CFont(const BR_CModule& module,
				   FontId faceNameId,
				   FontSize height,
				   FontStyle style);

	BR_CFont();
	BR_CFont(const BR_CFont& font);
	BR_CFont& operator=(const BR_CFont& font);

	virtual~ BR_CFont();

	BR_Boolean SetName(const BR_TString<BR_Char>& newName);
	BR_Boolean SetSize(const FontSize newSize);
	BR_Boolean SetStyle(const FontStyle newStyle);

	BR_Boolean Set(const BR_TString<BR_Char>& faceName,
				   FontSize height,
				   FontStyle fStyle);

	BR_Boolean Set(FontId faceNameId,
				   FontSize height,
				   FontStyle fStyle);

	BR_Boolean Set(const BR_CModule& module,
						 FontId faceNameId,
						 FontSize height,
						 FontStyle style);

	// Attribute access methods
	void GetName(BR_TString<BR_Char>& buffer) const;
	FontSize GetSize() const;
	FontStyle GetStyle() const;
	FontId GetId() const;

	BR_CFont::FontSize GetScaledSize(const BR_CView &pane) const;// ?INTERNAL?
	FontStyle BedGetPlatformStyle() const;		// ?INTERNAL?

protected:
	virtual BR_CGraphicsTool* GetCurrentTool(const BR_CCanvas& canvas) const;
	virtual void SetCurrentTool(BR_CCanvas& canvas,
								BR_CGraphicsTool* graphicsTool) const;
	virtual void SetupTool(BR_CView& pane,
						   GraphicsToolSelectionOptions selectionOptions,
						   BR_SGraphicsToolSuspendResumeState* state);
	virtual void RestoreNullTool(BR_CView& pane);

	BR_CFont(const BR_CBedDeferredTool& deferred);
	virtual void OnAttributeChange();
	void Create();
	void Dispose();

	BR_Boolean Set(const BR_TString<BR_Char>& faceName,
				   FontSize height,
				   FontStyle fStyle,
				   BR_Boolean fromCtor);

	BR_Boolean Set(FontId faceNameId,
				   FontSize height,
				   FontStyle fStyle,
				   BR_Boolean fromCtor);

	BR_Boolean Set(const BR_CModule& module,
						 FontId faceNameId,
						 FontSize height,
						 FontStyle style,
						 BR_Boolean fromCtor);

private:
	BR_CCharString32 fFaceName;			// The face name of the current font
	FontSize fFontSize;				// Size in points
	FontStyle fFontStyle;			// Style -- BEDFS_xxx
	FontId fFontId;					// Name Id, so we can check for kEnclosureFont

//----------------------------------------------------------------------------------------
// Windows
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	BR_CFont(LPLOGFONT lpLogFont);
	BR_CFont(const BR_CModule& module);
	void GetLogFont(LOGFONT& lf) const;

	HANDLE BedWinRequestHandle(unsigned short size);
	static void BedWinReleaseHandle(HANDLE fontHandle);

protected:
	virtual void Unselect(BR_CView& pane,
						  GraphicsToolSelectionOptions selectionOptions,
						  BR_SGraphicsToolSuspendResumeState* state);

	// We implement extended and condensed font styles by setting extra char spacing
	//  There is 1 unit of extra spacing per every kWin???TextCharExtra units of font size
	//  We only adjust spacing if font size is greater than kWin???SizeMin
	enum
	{
		kWinCondensedTextCharExtra = 16, kWinCondensedTextSizeMin = 8, kWinExtednedTextCharExtra = 8, kWinExtendedTextSizeMin = 6
	};
#endif

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	enum
	{
		kNoMacFontNum = -1						// To set fMacFontNumber to something invalid
	};


	short GetMacFontNum() const;
	BR_Boolean GetInherit() const;

private:
	short fMacFontNumber;							// font number used for the Mac
	BR_Boolean fMacInherited;
#endif

	BR_SETCLASSNAME(BR_CFont);
};

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CFont::GetMacFontNum
//----------------------------------------------------------------------------------------

inline short BR_CFont::GetMacFontNum() const
{
	return (fMacFontNumber);
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CFont::GetInherit
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CFont::GetInherit() const
{
	return (fMacInherited);
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CFont::GetName
//----------------------------------------------------------------------------------------

inline void BR_CFont::GetName(BR_TString<BR_Char>& buffer) const
{
	buffer = fFaceName;
}

//----------------------------------------------------------------------------------------
//	BR_CFont::GetSize
//----------------------------------------------------------------------------------------

inline BR_CFont::FontSize BR_CFont::GetSize() const
{
	return fFontSize;
}

//----------------------------------------------------------------------------------------
//	BR_CFont::GetStyle
//----------------------------------------------------------------------------------------

inline BR_CFont::FontStyle BR_CFont::GetStyle() const
{
	return fFontStyle;
}

//----------------------------------------------------------------------------------------
//	BR_CFont::GetId
//----------------------------------------------------------------------------------------

inline BR_CFont::FontId BR_CFont::GetId() const
{
	return fFontId;
}

//========================================================================================
//	class BR_CDeferredFont
//========================================================================================

class BR_CDeferredFont : public BR_CFont
{
public:
	BR_CDeferredFont(const BR_CModule& module,
					 FontId faceNameId,
					 FontSize height,
					 FontStyle newStyle);


	virtual~ BR_CDeferredFont();

protected:
	virtual void OnAttributeChange();

	BR_SETCLASSNAME(BR_CDeferredFont);
};

#endif


