#if !defined(BRDRAGDR_H) && !defined(__BEDRC__)
#define BRDRAGDR_H
//========================================================================================
//
//     File:		BrDragDr.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	3/24/92
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================


#ifndef BRMOUSEA_H
#include "BRMouseA.h"
#endif

#ifndef BRCURSOR_H
#include "BRCursor.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CView;
class BR_CPoint;

//========================================================================================
//	BR_CDragDrop
//
//		BR_CDragDrop is a cross-view mouse tracking action.  
//========================================================================================

class BR_CDragDrop : public BR_CMouseAction
{
public:
	BR_CDragDrop(BR_CView* originatingView);
	virtual ~BR_CDragDrop();

	virtual void BeginTracking(const BR_CPoint& startPoint);
	virtual void KeepTracking(const BR_CPoint& currentPoint);
	virtual void EndTracking(const BR_CPoint& dropPoint);
	BR_CView* GetOriginator() const;
	virtual BR_CCursor* GetCursor(const BR_CPoint& cursorPoint) const;

protected:
	BR_CView* GetDestinationView(BR_CPoint& ptOriginator) const;

	BR_CCursor* fNoDropCursor;

private:
	BR_CView* fLastView;

	BR_SETCLASSNAME(BR_CDragDrop);
};



#endif
