#if !defined(BRDOS_H) && !defined(__BEDRC__)
#define BRDOS_H
//========================================================================================
//
//     File:		BRDOS.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	8/1/92
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRBFM_H
#include "BRBFM.h"
#endif

#ifndef BRFILE_H
#include "BRFile.h"
#endif


#ifdef BR_BUILD_WIN
//========================================================================================
//	CLASS BR_DOS
//========================================================================================

class BR_DOS
{
public:

	typedef unsigned short int DOSError;
	enum Error
	{
		kNoError, 
		kInvalidFunction, 
		kFileNotFound, 
		kPathNotFound, 
		kTooManyOpenFiles, 
		kAccessDenied, 
		kInvalidHandle, 
		kArenaTrashed, 
		kNotEnoughMemory, 
		kInvalidBlock, 
		kBadEnvironment, 
		kBadFormat, 
		kInvalidAccess, 
		kInvalidData, 
		kInvalidDrive = 0xF, 
		kCurrentDirectory, 
		kNotSameDevice, 
		kNoMoreFiles, 
		kWriteProtect, 
		kBadUnit, 
		kNotReady, 
		kBadCommand, 
		kCRC, 
		kBadLength, 
		kSeek, 
		kNotDOSDisk, 
		kSectorNotFound, 
		kOutOfPaper, 
		kWriteFault, 
		kReadFault, 
		kGenFailure, 
		kSharingViolation, 
		kLockViolation, 
		kWrongDisk, 
		kFCBUnavailable, 
		kSharingBufferExceeded,
		kCodePageMismatched,
		kHandleEOF,
		kHandleDiskFull,
		kNotSupported = 0x32,
		kRemNotList,
		kDuplicateName,
		kBadNetpath,
		kNetworkBusy,
		kDevNotExist,
		kTooManyCmds,
		kADAPHardwareErr,
		kBadNetResp,
		kUnexpextedNetErr,
		kBadRemAdap,
		kPrintqFull,
		kNoSpoolSpace,
		kPrintCancelled,
		kNetnameDeleted,
		kNetworkAccessDenied,
		kBadDevType,
		kBadNetName,
		kTooManyNames,
		kTooManySess,
		kSharingPaused,
		kRequestNotAccepted,
		kRedirPaused,
		kFileExists = 0x50,
		kDuplicateFCB,
		kCannotMakeDirEntry,
		kFailIOnHardwareError,
		kOutOfStructures,
		kAlreadyAdssigned,
		kInvalidPassword,
		kInvalidParameter, 
		kNetWriteFault, 
		kSysCompNotLoaded = 0x5A
	};

	// Wrappers to DOS functions. They each return an fError as documented
	// in the "MS-DOS Programmers Reference: Version 5.0".
	// 
	// A stupid implementation note: ZTC doesn't have inilne assembly, so we
	// have written these funcitons in Microsoft C 6.0 (BRUtlty.c)

	static Error MoveFilePointer(HFILE fileHandle,
								 BR_CAbstractFileAccess::BufferLength Offset,
								 BR_CFile::MoveMethods theMoveMethod,
								 BR_CAbstractFileAccess::BufferLength& newPosition);
	// 42h

	static Error CreateFile(const char* fileName,
							HFILE& fileHandle);
	// 3Ch							

	static Error DeleteFile(const char* fileName);
	// 41h

	static Error OpenFile(const char* fileName,
						  BR_CAccessPermission::Access fFileAccess,
						  HFILE& fileHandle);
	// 3Dh

	static Error CloseFile(HFILE fileHandle);
	// 3Eh

	static Error WriteFile(HFILE fileHandle,
						   BR_CAbstractFileAccess::BufferLength maxBytes,
						   void* buffer,
						   BR_CAbstractFileAccess::BufferLength& actualWritten);
	// 40h This is More than just a wrapper - normally this call can't write
	// More than a shorts worth of data at a time. This routine can write a longs
	// worth. 

	static Error ReadFile(HFILE fileHandle,
						  BR_CAbstractFileAccess::BufferLength maxBytes,
						  void* buffer,
						  BR_CAbstractFileAccess::BufferLength& actualRead);
	// 3Fh This is More than just a wrapper - normally this call can't read
	// More than a shorts worth of data at a time. This routine can read a longs
	// worth. 

};
#endif 

#endif 