#if !defined(BRDOCUME_H) && !defined(__BEDRC__)
#define BRDOCUME_H
//========================================================================================
//
//     File:		BRDocume.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDIRECT_H
#include "BRDirect.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CFile;
class BR_CFileStream;
class BR_CPrinterInfo;
class BR_CPrinter;
class BR_CView;
class BR_CFileSpecification;
class BR_CPrintingProgressDialog;
class BR_CStream;
//template<class tCharacter>
//class BR_TString;

//========================================================================================
//	CLASS BR_CDocument
//
//		The main class for presenting and manipulating information.  You
//		can think of a document as the association of one or more windows,
//		a file, and a set of panes.
//
//========================================================================================

class BR_CDocument : public BR_CDirector
{
public:
	typedef unsigned short int MemoryError;

	enum AdornPhase
	{
		kAdornBeforePrinting, kAdornAfterPrinting
	};

	virtual~ BR_CDocument();

	virtual void AdornPage(unsigned long pageNum,
							 AdornPhase	phase,
							 BR_CView& adornPagePane);

	virtual BR_Boolean ConfirmClose(BR_Boolean quitting);
	virtual BR_Boolean DoCommand(CommandId theId,
								 BR_CObject* notifier,
								 BR_Boolean callSupervisor = TRUE);

	virtual void DoRevert();

	virtual BR_Boolean DoSave();

	virtual BR_Boolean DoSaveAs(const BR_CFileSpecification& theFileSpec);

	virtual BR_Boolean DoSaveFileAs();

	BR_CFileStream* GetFileStream() const;
	BR_CView* GetMainPane() const;
	BR_CPrinterInfo* GetPrinterInfo() const;

	virtual void DoneWithAdornPagePane(unsigned long,
										 AdornPhase phase,
										 BR_CView* adornPagePane) const;
	virtual BR_CView* GetAdornPagePane(unsigned long ,
										 AdornPhase phase);
	virtual BR_CDocument * GetDocument();
	virtual void GetName(BR_TString<BR_Char>& strName) const;
	virtual unsigned long GetPageCount() const;
	virtual BR_CView* GetPrintPane() const;


	void InitDocument(BR_CBureaucrat* itsSupervisor,
								BR_Boolean printable,
								BR_Boolean addToApp);

	BR_Boolean IsDirty() const;

	virtual void NameWindow(BR_CWindow& theWindow) const;

	virtual BR_Boolean NewFile();

	virtual void Notify(BR_CAction* theAction,
						BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean OpenFile(const BR_CFileSpecification& theFileSpec);

	virtual BR_Boolean OutOfMemory(MemoryError severity);

	virtual BR_Boolean PickFileName(BR_CFileSpecification*& theFileSpec);

	void SetDirty(BR_Boolean dirty);
	void SetFileStream(BR_CFileStream* newFile);
	void SetMainPane(BR_CView* theMainPane);

	virtual void UpdateMenus(BR_CMenuBar& theMenuBar,
							 BR_Boolean callSupervisor = TRUE);

	virtual void UpdateUndo();

protected:
	BR_CDocument();
	BR_CDocument(BR_CBureaucrat* itsSupervisor,
						   BR_Boolean printable,
						   BR_Boolean addToApp = TRUE);
	void InitPrinter(BR_CStream& theStream);
	void InitPrinter();

	virtual void DoDocumentPrintSetup();
	virtual BR_Boolean DoJobDialog();
	virtual void DoPrint();
	virtual void DoPrinterPrintSetup();
	virtual void DoPrintSetupChange() const;

	BR_CAction* GetLastAction() const;
	void GetPageSize(BR_CRectangle& rPage) const;
	void GetPrintPageRange(unsigned long& nFirstPage,
									 unsigned long& nLastPage) const;

	virtual BR_CPrinter* MakePrinter();
	virtual BR_CPrintingProgressDialog* MakePrintingDialog(BR_CPrinter* thePrinter);
	virtual BR_CPrinterInfo* MakePrinterInfo(BR_CStream& Stream);
	virtual BR_CPrinterInfo* MakePrinterInfo();

	virtual void Print();
	virtual void PrintPage(BR_CPrinter& thePrinter,
							 unsigned long pageNumber,
							 BR_CPrintingProgressDialog& theStatusDialog);
	virtual unsigned long PrintPages(BR_CPrinter& thePrinter,
									   unsigned long nFirstPage,
									   unsigned long nLastPage,
									   unsigned long& nLastPageAttempted,
									   BR_CPrintingProgressDialog& theStatusDialog);

	void SetLastAction(BR_CAction* theAction);
	void SetPrinterInfo(BR_CPrinterInfo* thePrinterInfo);

private:
	BR_Boolean fInitialized:1;					// is instance initialized?
	BR_Boolean fActionUndone:1;					// has an action been undone?
	BR_Boolean fCanPrint:1;						// can we print this?
	BR_Boolean fIsDirty:1;						// was the document changed?
	BR_Boolean fInDocumentList:1;				// are we in the document list?
	BR_CView* fMainPane;						// the main pane of the document
	BR_CFileStream* fFileStream;				// the document's file specifier
	BR_CAction* fLastAction;					// the last action (for undoing)
	BR_CPrinterInfo* fPrinterInfo;				// the document's printer info

	BR_SETCLASSNAME(BR_CDocument);
};

//----------------------------------------------------------------------------------------
// BR_CDocument::GetMainPane
//----------------------------------------------------------------------------------------

inline BR_CView* BR_CDocument::GetMainPane() const
{
	return fMainPane;
}

//----------------------------------------------------------------------------------------
// BR_CDocument::GetFileStream
//----------------------------------------------------------------------------------------

inline BR_CFileStream* BR_CDocument::GetFileStream() const
{
	return fFileStream;
}

//----------------------------------------------------------------------------------------
// BR_CDocument::SetFileSpecification
//----------------------------------------------------------------------------------------

inline void BR_CDocument::SetFileStream(BR_CFileStream* newFile)
{
	fFileStream = newFile;
}

//----------------------------------------------------------------------------------------
// BR_CDocument::IsDirty
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDocument::IsDirty() const
{
	return fIsDirty;
}

//----------------------------------------------------------------------------------------
// BR_CDocument::SetDirty
//----------------------------------------------------------------------------------------

inline void BR_CDocument::SetDirty(BR_Boolean dirty)
{
	fIsDirty = dirty;
}

//----------------------------------------------------------------------------------------
// BR_CDocument::GetPrinterInfo
//----------------------------------------------------------------------------------------

inline BR_CPrinterInfo* BR_CDocument::GetPrinterInfo() const
{
	return fPrinterInfo;
}

//----------------------------------------------------------------------------------------
// BR_CDocument::SetPrinterInfo
//----------------------------------------------------------------------------------------

inline void BR_CDocument::SetPrinterInfo(BR_CPrinterInfo* thePrinterInfo)
{
	fPrinterInfo = thePrinterInfo;
}

//----------------------------------------------------------------------------------------
// BR_CDocument::GetLastAction
//----------------------------------------------------------------------------------------

inline BR_CAction* BR_CDocument::GetLastAction() const
{
	return fLastAction;
}

//----------------------------------------------------------------------------------------
// BR_CDocument::SetLastAction
//----------------------------------------------------------------------------------------

inline void BR_CDocument::SetLastAction(BR_CAction* theAction)
{
	fLastAction = theAction;
}

#endif
