#if !defined(BRDEFERM_H) && !defined(__BEDRC__)
#define BRDEFERM_H
//========================================================================================
//
//     File:			BRDeferM.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	Wed 03-Apr-1991
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifdef BR_BUILD_WIN

#ifndef   BROBJECT_H
#include "BRObject.h"
#endif

#ifndef   BRRECT_H
#include "BRRect.h"
#endif

#if defined(BR_BUILD_WIN) && !defined(__INC_WINDOWS)
#include <windows.h>
#endif

//========================================================================================
// CLASS BR_CBedWinDeferMove
//
// A class that uses BeginDeferWindowPos() and related Windows functions to defer multiple
// window move commands. Once all such commands have been received, the window can be
// moved (or resized) just once, saving time
//========================================================================================

class BR_CBedWinDeferMove : public BR_CObject
{
public:
	BR_CBedWinDeferMove(unsigned short begCount = 1);
	virtual~ BR_CBedWinDeferMove();

private:
	BR_PlatformHandle fDefereMoveHandle;

public:											// Implementation
	BR_PlatformHandle GetHandle() const;
	void SetHandle(BR_PlatformHandle hNew);


	BR_Boolean DoDeferredMove(const BR_PlatformHandle hWnd,
							  const BR_CRectangle &r,
							  const BR_Boolean redraw);

	BR_SETCLASSNAME(BR_CBedWinDeferMove);
};

//----------------------------------------------------------------------------------------
//	BR_CBedWinDeferMove::GetHandle
//----------------------------------------------------------------------------------------

inline BR_PlatformHandle BR_CBedWinDeferMove::GetHandle() const
{
	return fDefereMoveHandle;
}

//----------------------------------------------------------------------------------------
//	BR_CBedWinDeferMove::SetHandle
//----------------------------------------------------------------------------------------

inline void BR_CBedWinDeferMove::SetHandle(BR_PlatformHandle hNew)
{
	fDefereMoveHandle = hNew;
}

#endif

#endif

