#if !defined(BRCOLORC_H) && !defined(__BEDRC__)
#define BRCOLORC_H
//========================================================================================
//
//     File:		BRColorC.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	December 23, 1991
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDLGDIR_H
#include "BRDlgDir.h"
#endif

#ifndef BRCOLOR_H
#include "BRcolor.h"
#endif

//========================================================================================
//	Forward class declaration
//========================================================================================

class BR_CStream;

//========================================================================================
//	BR_CColorChooser
//========================================================================================

class BR_CColorChooser : public BR_CDialogDirector
{
public:
	BR_CColorChooser(BR_CApplication *application);
	BR_CColorChooser(BR_CBureaucrat *supervisor,
					BR_CView *enclosure,
					const BR_CModule& module,
					BR_ResourceId resourceId);

	virtual~ BR_CColorChooser();

	void SetColor(const BR_CColor& initColor);
	BR_CColor GetColor() const;
	virtual void ShowDialog();

	void SaveCustomColors(BR_CStream& stream);
	void LoadCustomColors(BR_CStream& stream);

private:
	BR_CColor Color;
	BR_CColor::RGBValue fCustomColors[16];
};

#endif


