#if !defined(BRCLIPBO_H) && !defined(__BEDRC__)
#define BRCLIPBO_H
//========================================================================================
//
//     File:		BRClipBo.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCCOLLU_H
#include "BCCollU.h"
#endif

#ifndef BRDOCUME_H
#include "BRDocume.h"
#endif

#ifndef BRBEDEXC_H
#include "BRBedExc.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__TYPES__)
#include <Types.h>
#endif

//========================================================================================
//	CLASS BR_CClipboard
//
//		A very abstract class subclassed from BR_CDocument which basically
//		provides a window through which data can be viewed-- that is, a
//		'clipboard viewer'
//
//========================================================================================

class BR_CClipboard : public BR_CDocument
{
public:
	BR_CClipboard(BR_CApplication* itsSupervisor);
	virtual~ BR_CClipboard();

	virtual BR_Boolean ShowViewer();
	virtual void CloseWindow(BR_CWindow *aWindow);
	virtual BR_Boolean ConfirmClose(BR_Boolean quitting);

#ifdef BR_BUILD_MAC
public:
	typedef unsigned long int ClipBoardFormat;			// ResType doesn't work because defined as unsigned long
	enum BR_ClipBoardFormatConstants
	{
		kText = 'TEXT', kPicture = 'PICT'
	};

	static const ClipBoardFormat kClipFormatDontCare;

	virtual void RenderAll();					//??Internal??
	virtual void ChangeNotify();				//??Internal??
#endif

#ifdef BR_BUILD_WIN
public:
	typedef unsigned long ClipBoardFormat;
	enum BR_ClipBoardFormatConstants
	{
		kText = CF_TEXT, kBitmap = CF_BITMAP, kPicture = CF_METAFILEPICT, kSYLK = CF_SYLK, kDIF = CF_DIF, kTIFF = CF_TIFF
	};

	static const ClipBoardFormat kClipFormatDontCare;

	//??Internal??
	virtual LONG Dispatch(WORD wMessage,
						  WORD wParam,
						  LONG lParam,
						  BR_Boolean fCallDefaultProc = TRUE) = 0;
#endif

	BR_SETCLASSNAME(BR_CClipboard);
};

//========================================================================================
//	CLASS BR_CScrapConverter
//
//		Used by BR_CDeferredClipboard objects.  Scrap converter objects convert
//		data between the application format and the clipboard formats.  Each
//		scrap converter class you define can process one and only one type of
//		clipboard format.  In addition, each may be either a "read", "write",
//		or a "read-write" type of converter.  A "read" scrap converter can
//		only read from its specified clipboard format. A "write" scrap
//		converter can only write to its specified clipboard format. A
//		"read-write" scrap converter can read or write to its specified
//		clipboard format.  Thus for each clipboard format your application
//		supports, you will define one or two subclasses of BR_CScrapConverter.
//
//========================================================================================

class BR_CScrapConverter : public BR_CObject
{
public:
	BR_CScrapConverter(BR_CClipboard::ClipBoardFormat id,
					   BR_Boolean reader,
					   BR_Boolean writer);

	virtual~ BR_CScrapConverter();

	virtual BR_PlatformHandle WriteData(const BR_CObject& theData) const;
	virtual BR_CObject* ReadData(BR_PlatformHandle theData) const;
	virtual BR_Boolean CanWrite(const BR_CObject& data) const;
	virtual BR_Boolean CanRead() const;
	BR_CClipboard::ClipBoardFormat GetFormat() const;

protected:
	BR_Boolean fCanReadFormat;					// can read a clipboard format
	BR_Boolean fCanWriteFormat;					// can write a clipboard format
	BR_CClipboard::ClipBoardFormat fClipboardFormat;// the clipboard format we use

	BR_SETCLASSNAME(BR_CScrapConverter);
};

//----------------------------------------------------------------------------------------
// BR_CScrapConverter::GetFormat
//----------------------------------------------------------------------------------------

inline BR_CClipboard::ClipBoardFormat BR_CScrapConverter::GetFormat() const
{
	return fClipboardFormat;
}

//========================================================================================
//	CLASS BR_CPublicClipboard
//
//		Simply provides C++ wrappers for accessing the clipboard routines of
//		whatever platform your application is running on.  Normally you would
//		use an instance of BR_CDeferredClipboard in your application.
//
//========================================================================================

class BR_CPublicClipboard : public BR_CClipboard
{
public:

	BR_CPublicClipboard(BR_CApplication* itsSupervisor);
	virtual~ BR_CPublicClipboard();

	virtual BR_Boolean CloseClipboard(BR_Boolean);
	virtual BR_Boolean OpenClipboard(BR_Boolean modify);

	BR_PlatformHandle GetData(ClipBoardFormat id);

	virtual BR_Boolean IsFormatAvailable(ClipBoardFormat formatId) const;

	virtual BR_CClipboard::ClipBoardFormat NewFormat(const BR_TString<BR_Char>& theClipboardFormat) const;

	BR_Boolean PutData(ClipBoardFormat id,
					   BR_PlatformHandle pData);

	virtual BR_Boolean ShowViewer();

	BR_Boolean BCLChangedClipboard() const;			//??Internal??
protected:
	BR_Boolean PutData(ClipBoardFormat id,
					   BR_PlatformHandle pData,
					   BR_Boolean acceptNullData);

	BR_CView* fViewerPane;						// the pane showing the clipboard data
	ClipBoardFormat fViewFormat;				// the kind of view

private:
	BR_Boolean fChangedByMe;					// change to the clipboard by us?

#ifdef BR_BUILD_MAC
public:
	virtual void InstallClipboardDisplayPane(BR_CWindow* window);
	virtual void NewWindow();

	virtual void RenderAll();					//??Internal??
	virtual void ChangeNotify();				//??Internal??

private:
	BR_PlatformHandle fLastData;				// deleted by PutData() or ChangeNotify()
	BR_ResourceType fLastType;					// type of the data in the BR_PlatformHandle
	void DeleteLastData();
#endif

#ifdef BR_BUILD_WIN
public:
	virtual BR_Boolean BR_CPublicClipboard::GetFormatName(ClipBoardFormat id,
											  BR_TString<BR_Char>& OutFormatName) const;

	virtual LONG Dispatch(WORD wMessage,
						  //??Internal??
						  WORD wParam,
						  LONG lParam,
						  BR_Boolean fCallDefaultProc = TRUE);
#endif

	BR_SETCLASSNAME(BR_CPublicClipboard);
};

//----------------------------------------------------------------------------------------
// BR_CPublicClipboard::BCLChangedClipboard
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CPublicClipboard::BCLChangedClipboard() const
{
	return fChangedByMe;
}

//----------------------------------------------------------------------------------------
// BR_CPublicClipboard::PutData
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CPublicClipboard::PutData(ClipBoardFormat id, BR_PlatformHandle pData)
{
	return PutData(id, pData, FALSE);
}


//========================================================================================
// BR_CAcquirePublicClipboard
//		Resource acquisition helper class. The ctor calls Open() and the dtor calls
//		Close() on the public clipboard.
//========================================================================================

class BR_CAcquirePublicClipboard : public BR_CObject
{
public:
	BR_CAcquirePublicClipboard(BR_CPublicClipboard* publicClipboard,
							   BR_Boolean modify);
	virtual~ BR_CAcquirePublicClipboard();

private:
	BR_CPublicClipboard* fPublicClipboard;
	BR_Boolean fModify;
};

//========================================================================================
//	CLASS BR_CDeferredClipboard
//
//		This is the clipboard subclass that most applications would use.  Its
//		name refers to the fact that on the Microsoft Windows platform, the
//		rendering of a cut or Copy to the clipboard is deferred until an
//		attempt to paste from the clipboard occurs.  Only the clipboard format
//		requested by the pasting application is rendered, thus saving the time
// 		and fSpace associated with rendering all the possible clipboard formats
//		at the time of the cut or Copy request.
//
//		The BR_CDeferredClipboard class will be available on all platforms,
//		though not all implementations will necessarily support deferred
//		rendering.
//
//========================================================================================

class BR_CDeferredClipboard : public BR_CPublicClipboard
{
public:
	BR_CDeferredClipboard(BR_CApplication* itsSupervisor);
	virtual~ BR_CDeferredClipboard();

	BR_CObject* GetData();
	virtual BR_Boolean HasData() const;
	void PutData(BR_CObject* data);
	virtual BR_Boolean RegisterConverter(BR_CScrapConverter* scrapConverter);

	virtual void ChangeNotify();				//??Internal??
	void EnsureHavePublic();					//??Internal??
	void Render(const BR_CObject* data,
				 ClipBoardFormat formatId);
	virtual void RenderAll();					//??Internal??
	void RenderAll(const BR_CObject* data,
					BR_Boolean Render = TRUE);	//??Internal??
	BR_Boolean RenderOne(const BR_CObject* data,
						const BR_CScrapConverter& scrapConverter);//??Internal??
	void ToPrivate();							//??Internal??

protected:
	BR_CObject* GetOurData() const;
	const BC_TCollection<BR_CScrapConverter *> *GetOurTypes() const;

	BR_Boolean HavePublic() const;

	void SetOurData(BR_CObject* newData);
	void SetPublic(BR_Boolean HavePublic);

private:
	BC_TUnboundedCollection<BR_CScrapConverter *, BC_CUnmanaged> fRegisteredTypes;
		// the scrap converters registered
		
	BR_CObject* fClipboardData;					// the data in the clipboard
	BR_Boolean fHavePublic;						// do we have public data?

#ifdef BR_BUILD_WIN
public:
	virtual LONG Dispatch(WORD wMessage,
						  WORD wParam,
						  LONG lParam,
						  BR_Boolean callDefaultProc = TRUE);

	HWND fNextViewer;							// Next clipboard viewer in the chain
#endif

	BR_SETCLASSNAME(BR_CDeferredClipboard);
};

//----------------------------------------------------------------------------------------
// BR_CDeferredClipboard::GetOurTypes
//----------------------------------------------------------------------------------------

inline const BC_TCollection<BR_CScrapConverter *> *
BR_CDeferredClipboard::GetOurTypes() const
{
    return &fRegisteredTypes;
}

//----------------------------------------------------------------------------------------
// BR_CDeferredClipboard::GetOurData
//----------------------------------------------------------------------------------------

inline BR_CObject* BR_CDeferredClipboard::GetOurData() const
{
    return fClipboardData;
}

//----------------------------------------------------------------------------------------
// BR_CDeferredClipboard::SetOurData
//----------------------------------------------------------------------------------------

inline void BR_CDeferredClipboard::SetOurData(BR_CObject* newData)
{
    fClipboardData = newData;
}

//----------------------------------------------------------------------------------------
// BR_CDeferredClipboard::HavePublic
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CDeferredClipboard::HavePublic() const
{
    return fHavePublic;
}

//----------------------------------------------------------------------------------------
// BR_CDeferredClipboard::SetPublic
//----------------------------------------------------------------------------------------

inline void BR_CDeferredClipboard::SetPublic(BR_Boolean havePublic)
{
    fHavePublic = havePublic;
}


//========================================================================================
//	Class BR_XClipboard 
//========================================================================================

class BR_XClipboard : public BR_XBedException
{
public:
	_BR_EXCEPTION_DEFINE(BR_XClipboard);
protected:
	BR_XClipboard();
	BR_XClipboard(const BR_CClipboard *aClipboard);
	BR_XClipboard(const BR_CClipboard *aClipboard, const PlatformError theError);
	virtual ~BR_XClipboard();
	const BR_CClipboard* GetClipboard() const;
private:
	const BR_CClipboard *fClipboard;
};

//========================================================================================
//	Class BR_XUnknownClipboard 
//========================================================================================

class BR_XUnknownClipboard : public BR_XClipboard
{
public:
	BR_XUnknownClipboard(const BR_CClipboard *aClipboard);
	BR_XUnknownClipboard(const BR_CClipboard *aClipboard, const PlatformError theError);
	virtual ~BR_XUnknownClipboard();
	_BR_EXCEPTION_DEFINE(BR_XUnknownClipboard);
};

//========================================================================================
//	Class BR_XCantOpenClipboard 
//========================================================================================

class BR_XCantOpenClipboard : public BR_XClipboard
{
public:
	BR_XCantOpenClipboard(const BR_CClipboard *aClipboard);
	BR_XCantOpenClipboard(const BR_CClipboard *aClipboard, const PlatformError theError);
	virtual ~BR_XCantOpenClipboard();
	_BR_EXCEPTION_DEFINE(BR_XCantOpenClipboard);
};

//========================================================================================
//	Class BR_XCantCloseClipboard 
//========================================================================================

class BR_XCantCloseClipboard : public BR_XClipboard
{
public:
	BR_XCantCloseClipboard(const BR_CClipboard *aClipboard);
	virtual ~BR_XCantCloseClipboard();
	_BR_EXCEPTION_DEFINE(BR_XCantCloseClipboard);
};

//========================================================================================
//	Class BR_XCantPutClipboardData 
//========================================================================================

class BR_XCantPutClipboardData : public BR_XClipboard
{
public:
	BR_XCantPutClipboardData(const BR_CClipboard *aClipboard);
	BR_XCantPutClipboardData(const BR_CClipboard *aClipboard, const PlatformError theError);
	virtual ~BR_XCantPutClipboardData();
	_BR_EXCEPTION_DEFINE(BR_XCantPutClipboardData);
};

//========================================================================================
//	Class BR_XCantGetClipboardData 
//========================================================================================

class BR_XCantGetClipboardData : public BR_XClipboard
{
public:
	BR_XCantGetClipboardData(const BR_CClipboard *aClipboard);
	BR_XCantGetClipboardData(const BR_CClipboard *aClipboard, const PlatformError theError);
	virtual ~BR_XCantGetClipboardData();
	_BR_EXCEPTION_DEFINE(BR_XCantGetClipboardData);
};

#ifdef BR_BUILD_WIN
//========================================================================================
//	Class xCantGetClipboardFormatName 
//========================================================================================

class xCantGetClipboardFormatName : public BR_XClipboard
{
public:
	xCantGetClipboardFormatName(const BR_CClipboard *aClipboard);
	virtual ~xCantGetClipboardFormatName();
	_BR_EXCEPTION_DEFINE(xCantGetClipboardFormatName);
};

//========================================================================================
//	Class xCantChangeClipboardViewer 
//========================================================================================

class xCantChangeClipboardViewer : public BR_XClipboard
{
public:
	xCantChangeClipboardViewer(const BR_CClipboard *aClipboard);
	virtual ~xCantChangeClipboardViewer();
	_BR_EXCEPTION_DEFINE(xCantChangeClipboardViewer);
};
#endif

//----------------------------------------------------------------------------------------
// BR_XUnknownClipboard::BR_XUnknownClipboard
//----------------------------------------------------------------------------------------

inline BR_XUnknownClipboard::BR_XUnknownClipboard(const BR_CClipboard *aClipboard) :
	BR_XClipboard(aClipboard)
{
}

//----------------------------------------------------------------------------------------
// BR_XUnknownClipboard::BR_XUnknownClipboard
//----------------------------------------------------------------------------------------

inline BR_XUnknownClipboard::BR_XUnknownClipboard(const BR_CClipboard *aClipboard,
						  					 const PlatformError theError) :
	BR_XClipboard(aClipboard, theError)
{
}

//----------------------------------------------------------------------------------------
// BR_XCantOpenClipboard::BR_XCantOpenClipboard
//----------------------------------------------------------------------------------------

inline BR_XCantOpenClipboard::BR_XCantOpenClipboard(const BR_CClipboard *aClipboard) :
	BR_XClipboard(aClipboard)
{
}

//----------------------------------------------------------------------------------------
// BR_XCantOpenClipboard::BR_XCantOpenClipboard
//----------------------------------------------------------------------------------------

inline BR_XCantOpenClipboard::BR_XCantOpenClipboard(const BR_CClipboard *aClipboard,
						  					  const PlatformError theError) :
	BR_XClipboard(aClipboard, theError)
{
}

//----------------------------------------------------------------------------------------
// BR_XCantCloseClipboard::BR_XCantCloseClipboard
//----------------------------------------------------------------------------------------

inline BR_XCantCloseClipboard::BR_XCantCloseClipboard(const BR_CClipboard *aClipboard) :
	BR_XClipboard(aClipboard)
{
}

//----------------------------------------------------------------------------------------
// BR_XCantPutClipboardData::BR_XCantPutClipboardData
//----------------------------------------------------------------------------------------

inline BR_XCantPutClipboardData::BR_XCantPutClipboardData(const BR_CClipboard *aClipboard) :
	BR_XClipboard(aClipboard)
{
}

//----------------------------------------------------------------------------------------
// BR_XCantPutClipboardData::BR_XCantPutClipboardData
//----------------------------------------------------------------------------------------

inline BR_XCantPutClipboardData::BR_XCantPutClipboardData(const BR_CClipboard *aClipboard,
						  					  		const PlatformError theError) :
	BR_XClipboard(aClipboard, theError)
{
}

//----------------------------------------------------------------------------------------
// BR_XCantGetClipboardData::BR_XCantGetClipboardData
//----------------------------------------------------------------------------------------

inline BR_XCantGetClipboardData::BR_XCantGetClipboardData(const BR_CClipboard *aClipboard) :
	BR_XClipboard(aClipboard)
{
}

//----------------------------------------------------------------------------------------
// BR_XCantGetClipboardData::BR_XCantGetClipboardData
//----------------------------------------------------------------------------------------

inline BR_XCantGetClipboardData::BR_XCantGetClipboardData(const BR_CClipboard *aClipboard,
						  					  		const PlatformError theError) :
	BR_XClipboard(aClipboard, theError)
{
}

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// xCantGetClipboardFormatName::xCantGetClipboardFormatName
//----------------------------------------------------------------------------------------

inline xCantGetClipboardFormatName::xCantGetClipboardFormatName(const BR_CClipboard *aClipboard) :
	BR_XClipboard(aClipboard)
{
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// xCantChangeClipboardViewer::xCantChangeClipboardViewer
//----------------------------------------------------------------------------------------

inline xCantChangeClipboardViewer::xCantChangeClipboardViewer(const BR_CClipboard *aClipboard) :
	BR_XClipboard(aClipboard)
{
}
#endif

#endif
