#if !defined(BRCHORE_H) && !defined(__BEDRC__)
#define BRCHORE_H
//========================================================================================
//
//     File:		BRChore.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/11/91
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BCTYPE_H
#include "BCType.h"
#endif

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRBUREAU_H
#include "BRBureau.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================
class BR_CView;
class BR_CModule;
//template<class tCharacter>
//class BR_TString;
class BR_CView;

//========================================================================================
// Constants
//========================================================================================
enum ChoreType
{
	kTimerChore = 1,
	kUrgentChore = 2,
	kIdleChore = 3,
	kActionChore = 4
};




//========================================================================================
//	BR_CChore
//
//      An abstract class for implementing timed, idle, or urgent chores
//      and actions.
//      To implement a chore, you'll first need to define a subclass of
//      BR_CChore.  In your chore subclass, you'll override the Do method in
//      order to implement the action you want it to take.
//========================================================================================
class BR_CChore : public BR_CObject
{
public:
	typedef BC_Index ChoreId;

	BR_CChore();
	virtual~ BR_CChore();

	virtual BR_Boolean Do() = 0;

	ChoreType GetType() const;

protected:
	void SetType(ChoreType choreType);

private:
	ChoreType fChoreType;

	BR_SETCLASSNAME(BR_CChore);
};



//========================================================================================
//	BR_CTimerChore
//
//  An abstract class.  BR_CTimerChore is subclassed in order to perform
//    a specified chore at a specified time interval
//========================================================================================
class BR_CTimerChore : public BR_CChore
{
public:
	BR_CTimerChore(BR_CView* thePane,
				   BR_Milliseconds timeInterval);
	virtual~ BR_CTimerChore();
	BR_CView* GetPane();

	virtual BR_Boolean Do() = 0;

private:
	BR_CView* fChorePane;						// The pane associated with this chore
	ChoreId fChoreId;							// The chore ID

	BR_SETCLASSNAME(BR_CTimerChore);
};



//========================================================================================
//	BR_CUrgentChore
//
//  An abstract class.  BR_CUrgentChore is subclassed in order to perform a specified  
//    chore immediately after the application processes the current event
//========================================================================================
class BR_CUrgentChore : public BR_CChore
{
public:
	BR_CUrgentChore(BR_Boolean isRecurring = FALSE);
	virtual~ BR_CUrgentChore();

	virtual BR_Boolean Do() = 0;
	BR_Boolean IsRecurring() const;

private:
	BR_Boolean fIsRecurring;

	BR_SETCLASSNAME(BR_CUrgentChore);
};



//========================================================================================
//	BR_CIdleChore
//
//  An abstract class.  BR_CIdleChore is subclassed in order to perform a specified 
//    chore When the application is idle.
//========================================================================================
class BR_CIdleChore : public BR_CChore
{
public:
	BR_CIdleChore();
	virtual~ BR_CIdleChore();
	virtual BR_Boolean Do() = 0;

	BR_SETCLASSNAME(BR_CIdleChore);
};



//========================================================================================
//	BR_CAction
//
//  An abstract class.  BR_CAction is subclassed in order to perform undo-able actions.
//    The last action that is performed by Do can be undone by Undo.  This undo, in 
//    turn, can be undone by calling Redo
//
//  The Undo slot in the Edit menu should reflect what currently can be undone.  For 
//    example, after a 'Cut', the user should see 'Undo Cut'.  These various undo 
//    strings need to be stored in resource files.  The undo string associated with 
//    this instance is pointed to by these fResourceModule and fStringID.
//========================================================================================
class BR_CAction : public BR_CChore
{
public:
	virtual~ BR_CAction();
	virtual BR_Boolean Do();					// Perform the action
	virtual BR_Boolean Undo();					// Undo the action
	virtual BR_Boolean Redo();					// Undo the undo
	virtual void GetDescription(BR_TString<BR_Char>& description) const;
	virtual void SetDescription(BR_TString<BR_Char>& description);

protected:
	BR_CAction(BR_CModule* stringResourceModule,
			   BR_ResourceId stringResourceID);
	BR_CAction();

private:
	BR_CModule* fResourceModule;				//The resource file the string is stored in
	BR_ResourceId fStringId;					//The ID of the string within the file

	BR_SETCLASSNAME(BR_CAction);
};



//========================================================================================
//	BR_CMenuHelpChore
//
//  Used to get help on a menu item while the menu is down.  This class is used with
//    both the Windows help system (using the F1 fKey) and Macintosh Balloon help.
//========================================================================================
class BR_CMenuHelpChore : public BR_CUrgentChore
{
public:
	BR_CMenuHelpChore(BR_CView* View,
					  BR_CBureaucrat::CommandId helpCommandId);
	virtual~ BR_CMenuHelpChore();

	virtual BR_Boolean Do();

private:
	BR_CBureaucrat::CommandId fHelpCommandId;	// Id of item to provide help for.
	BR_CView* fViewToHelp;						// Pointer to view asking for help.

	BR_SETCLASSNAME(BR_CMenuHelpChore);
};






//========================================================================================
//	CLASS BR_CChore
//========================================================================================

//----------------------------------------------------------------------------------------
//	BR_CChore::GetType
//----------------------------------------------------------------------------------------
inline ChoreType BR_CChore::GetType() const
{
	return (fChoreType);
}


//----------------------------------------------------------------------------------------
//	BR_CChore::SetType
//----------------------------------------------------------------------------------------
inline void BR_CChore::SetType(ChoreType choreType)
{
	fChoreType = choreType;
}



//========================================================================================
//	CLASS BR_CTimerChore
//========================================================================================

//----------------------------------------------------------------------------------------
//	BR_CTimerChore::GetPane
//----------------------------------------------------------------------------------------
inline BR_CView* BR_CTimerChore::GetPane()
{
	return (fChorePane);
}



//========================================================================================
//	CLASS BR_CUrgentChore
//========================================================================================

//----------------------------------------------------------------------------------------
//	BR_CUrgentChore::IsRecurring
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CUrgentChore::IsRecurring() const
{
	return (fIsRecurring);
}

#endif
